/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.connection;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Return;
import java.util.Collection;
import java.util.function.Consumer;
import org.springframework.amqp.rabbit.connection.PendingConfirm;

public interface PublisherCallbackChannel
extends Channel {
    public static final String RETURN_LISTENER_CORRELATION_KEY = "spring_listener_return_correlation";
    public static final String RETURNED_MESSAGE_CORRELATION_KEY = "spring_returned_message_correlation";

    public void addListener(Listener var1);

    public Collection<PendingConfirm> expire(Listener var1, long var2);

    public int getPendingConfirmsCount(Listener var1);

    public int getPendingConfirmsCount();

    public void addPendingConfirm(Listener var1, long var2, PendingConfirm var4);

    public Channel getDelegate();

    public void setAfterAckCallback(Consumer<Channel> var1);

    public static interface Listener {
        public void handleConfirm(PendingConfirm var1, boolean var2);

        @Deprecated
        default public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) {
            throw new UnsupportedOperationException("This should never be called; please open a GitHub issue with a stack trace");
        }

        default public void handleReturn(Return returned) {
            this.handleReturn(returned.getReplyCode(), returned.getReplyText(), returned.getExchange(), returned.getRoutingKey(), returned.getProperties(), returned.getBody());
        }

        public void revoke(Channel var1);

        public String getUUID();

        public boolean isConfirmListener();

        public boolean isReturnListener();
    }
}

