/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.crypto.encrypt;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.crypto.codec.Hex;
import org.springframework.security.crypto.encrypt.BytesEncryptor;
import org.springframework.security.crypto.encrypt.CipherUtils;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.util.EncodingUtils;

final class AndroidAesBytesEncryptor
implements BytesEncryptor {
    private final SecretKey secretKey;
    private final Cipher encryptor;
    private final Cipher decryptor;
    private final BytesKeyGenerator ivGenerator;
    private static final String AES_ALGORITHM = "AES/CBC/PKCS5Padding";

    public AndroidAesBytesEncryptor(String password, CharSequence salt, BytesKeyGenerator ivGenerator) {
        PBEKeySpec keySpec = new PBEKeySpec(password.toCharArray(), Hex.decode((CharSequence)salt), 1024, 256);
        SecretKey secretKey = CipherUtils.newSecretKey((String)"PBEWITHSHA256AND256BITAES-CBC-BC", (PBEKeySpec)keySpec);
        this.secretKey = new SecretKeySpec(secretKey.getEncoded(), "AES");
        this.encryptor = CipherUtils.newCipher((String)AES_ALGORITHM);
        this.decryptor = CipherUtils.newCipher((String)AES_ALGORITHM);
        this.ivGenerator = ivGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] bytes) {
        Cipher cipher = this.encryptor;
        synchronized (cipher) {
            byte[] iv = this.ivGenerator.generateKey();
            CipherUtils.initCipher((Cipher)this.encryptor, (int)1, (SecretKey)this.secretKey, (AlgorithmParameterSpec)new IvParameterSpec(iv));
            byte[] encrypted = CipherUtils.doFinal((Cipher)this.encryptor, (byte[])bytes);
            return EncodingUtils.concatenate((byte[][])new byte[][]{iv, encrypted});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] encryptedBytes) {
        Cipher cipher = this.decryptor;
        synchronized (cipher) {
            byte[] iv = this.ivPart(encryptedBytes);
            CipherUtils.initCipher((Cipher)this.decryptor, (int)2, (SecretKey)this.secretKey, (AlgorithmParameterSpec)new IvParameterSpec(iv));
            return CipherUtils.doFinal((Cipher)this.decryptor, (byte[])this.cipherPart(encryptedBytes, iv));
        }
    }

    private byte[] ivPart(byte[] encrypted) {
        return EncodingUtils.subArray((byte[])encrypted, (int)0, (int)this.ivGenerator.getKeyLength());
    }

    private byte[] cipherPart(byte[] encrypted, byte[] iv) {
        return EncodingUtils.subArray((byte[])encrypted, (int)iv.length, (int)encrypted.length);
    }
}

