/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionData;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.DuplicateConnectionException;
import org.springframework.social.connect.NoSuchConnectionException;
import org.springframework.social.connect.NotConnectedException;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class SQLiteConnectionRepository
implements ConnectionRepository {
    private final String userId;
    private final SQLiteOpenHelper repositoryHelper;
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final TextEncryptor textEncryptor;

    public SQLiteConnectionRepository(SQLiteOpenHelper repositoryHelper, ConnectionFactoryLocator connectionFactoryLocator, TextEncryptor textEncryptor) {
        this("1", repositoryHelper, connectionFactoryLocator, textEncryptor);
    }

    public SQLiteConnectionRepository(String userId, SQLiteOpenHelper repositoryHelper, ConnectionFactoryLocator connectionFactoryLocator, TextEncryptor textEncryptor) {
        this.userId = userId;
        this.repositoryHelper = repositoryHelper;
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.textEncryptor = textEncryptor;
    }

    public MultiValueMap<String, Connection<?>> findAllConnections() {
        String sql = this.selectFromUserConnection() + " where userId = ? order by providerId, rank";
        String[] selectionArgs = new String[]{this.userId};
        List<Connection<?>> resultList = this.queryForConnections(sql, selectionArgs);
        LinkedMultiValueMap connections = new LinkedMultiValueMap();
        Set registeredProviderIds = this.connectionFactoryLocator.registeredProviderIds();
        for (String string : registeredProviderIds) {
            connections.put((Object)string, Collections.emptyList());
        }
        for (Connection connection : resultList) {
            String providerId = connection.getKey().getProviderId();
            if (((List)connections.get((Object)providerId)).size() == 0) {
                connections.put((Object)providerId, new LinkedList());
            }
            connections.add((Object)providerId, (Object)connection);
        }
        return connections;
    }

    public List<Connection<?>> findConnections(String providerId) {
        String sql = this.selectFromUserConnection() + " where userId = ? and providerId = ? order by rank";
        String[] selectionArgs = new String[]{this.userId, providerId};
        return this.queryForConnections(sql, selectionArgs);
    }

    public <A> List<Connection<A>> findConnections(Class<A> apiType) {
        List<Connection<A>> connections = this.findConnections(this.getProviderId(apiType));
        return connections;
    }

    public MultiValueMap<String, Connection<?>> findConnectionsToUsers(MultiValueMap<String, String> providerUsers) {
        if (providerUsers == null || providerUsers.isEmpty()) {
            throw new IllegalArgumentException("Unable to execute find: no providerUsers provided");
        }
        StringBuilder providerUsersCriteriaSql = new StringBuilder();
        ArrayList<String> args = new ArrayList<String>(1 + providerUsers.size() * 2);
        args.add(this.userId);
        Iterator entries = providerUsers.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = (Map.Entry)entries.next();
            providerUsersCriteriaSql.append("providerId = ? and providerUserId in (?");
            args.add((String)entry.getKey());
            Iterator values = ((List)entry.getValue()).iterator();
            while (values.hasNext()) {
                String value = (String)values.next();
                args.add(value);
                if (!values.hasNext()) continue;
                providerUsersCriteriaSql.append(", ?");
            }
            providerUsersCriteriaSql.append(")");
            if (!entries.hasNext()) continue;
            providerUsersCriteriaSql.append(" or ");
        }
        String sql = this.selectFromUserConnection() + " where userId = ? and " + providerUsersCriteriaSql + " order by providerId, rank";
        String[] selectionArgs = args.toArray(new String[0]);
        List<Connection<?>> resultList = this.queryForConnections(sql, selectionArgs);
        LinkedMultiValueMap connectionsForUsers = new LinkedMultiValueMap();
        for (Connection<?> connection : resultList) {
            String providerId = connection.getKey().getProviderId();
            List userIds = (List)providerUsers.get((Object)providerId);
            ArrayList connections = (ArrayList)connectionsForUsers.get((Object)providerId);
            if (connections == null) {
                connections = new ArrayList(userIds.size());
                for (int i = 0; i < userIds.size(); ++i) {
                    connections.add(null);
                }
                connectionsForUsers.put((Object)providerId, connections);
            }
            String providerUserId = connection.getKey().getProviderUserId();
            int connectionIndex = userIds.indexOf(providerUserId);
            connections.set(connectionIndex, connection);
        }
        return connectionsForUsers;
    }

    public Connection<?> getConnection(ConnectionKey connectionKey) {
        String sql = this.selectFromUserConnection() + " where userId = ? and providerId = ? and providerUserId = ? order by rank";
        String[] selectionArgs = new String[]{this.userId, connectionKey.getProviderId(), connectionKey.getProviderUserId()};
        Connection<?> connection = this.queryForConnection(sql, selectionArgs);
        if (connection == null) {
            throw new NoSuchConnectionException(connectionKey);
        }
        return connection;
    }

    public <A> Connection<A> getConnection(Class<A> apiType, String providerUserId) {
        String providerId = this.getProviderId(apiType);
        return this.getConnection(new ConnectionKey(providerId, providerUserId));
    }

    public <A> Connection<A> getPrimaryConnection(Class<A> apiType) {
        String providerId = this.getProviderId(apiType);
        Connection<?> connection = this.findPrimaryConnection(providerId);
        if (connection == null) {
            throw new NotConnectedException(providerId);
        }
        return connection;
    }

    public <A> Connection<A> findPrimaryConnection(Class<A> apiType) {
        String providerId = this.getProviderId(apiType);
        return this.findPrimaryConnection(providerId);
    }

    public void addConnection(Connection<?> connection) {
        try {
            ConnectionData data = connection.createData();
            SQLiteDatabase db = this.repositoryHelper.getWritableDatabase();
            String sql = "select coalesce(max(rank) + 1, 1) as rank from UserConnection where userId = ? and providerId = ?";
            String[] selectionArgs = new String[]{this.userId, data.getProviderId()};
            Cursor c = db.rawQuery("select coalesce(max(rank) + 1, 1) as rank from UserConnection where userId = ? and providerId = ?", selectionArgs);
            c.moveToFirst();
            int rank = c.getInt(c.getColumnIndex("rank"));
            c.close();
            ContentValues values = new ContentValues();
            values.put("userId", this.userId);
            values.put("providerId", data.getProviderId());
            values.put("providerUserId", data.getProviderUserId());
            values.put("rank", Integer.valueOf(rank));
            values.put("displayName", data.getDisplayName());
            values.put("profileUrl", data.getProfileUrl());
            values.put("imageUrl", data.getImageUrl());
            values.put("accessToken", this.encrypt(data.getAccessToken()));
            values.put("secret", this.encrypt(data.getSecret()));
            values.put("refreshToken", this.encrypt(data.getRefreshToken()));
            values.put("expireTime", data.getExpireTime());
            db.insertOrThrow("UserConnection", null, values);
            db.close();
        }
        catch (SQLiteConstraintException e) {
            throw new DuplicateConnectionException(connection.getKey());
        }
    }

    public void updateConnection(Connection<?> connection) {
        ConnectionData data = connection.createData();
        SQLiteDatabase db = this.repositoryHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("displayName", data.getDisplayName());
        values.put("profileUrl", data.getProfileUrl());
        values.put("imageUrl", data.getImageUrl());
        values.put("accessToken", this.encrypt(data.getAccessToken()));
        values.put("secret", this.encrypt(data.getSecret()));
        values.put("refreshToken", this.encrypt(data.getRefreshToken()));
        values.put("expireTime", data.getExpireTime());
        String whereClause = "userId = ? and providerId = ? and providerUserId = ?";
        String[] whereArgs = new String[]{this.userId, data.getProviderId(), data.getProviderUserId()};
        db.update("UserConnection", values, "userId = ? and providerId = ? and providerUserId = ?", whereArgs);
        db.close();
    }

    public void removeConnections(String providerId) {
        SQLiteDatabase db = this.repositoryHelper.getWritableDatabase();
        String whereClause = "userId = ? and providerId = ?";
        String[] whereArgs = new String[]{this.userId, providerId};
        db.delete("UserConnection", "userId = ? and providerId = ?", whereArgs);
        db.close();
    }

    public void removeConnection(ConnectionKey connectionKey) {
        SQLiteDatabase db = this.repositoryHelper.getWritableDatabase();
        String whereClause = "userId = ? and providerId = ? and providerUserId = ?";
        String[] whereArgs = new String[]{this.userId, connectionKey.getProviderId(), connectionKey.getProviderUserId()};
        db.delete("UserConnection", "userId = ? and providerId = ? and providerUserId = ?", whereArgs);
        db.close();
    }

    private String selectFromUserConnection() {
        return "select userId, providerId, providerUserId, displayName, profileUrl, imageUrl, accessToken, secret, refreshToken, expireTime from UserConnection";
    }

    private Connection<?> findPrimaryConnection(String providerId) {
        String sql = this.selectFromUserConnection() + " where userId = ? and providerId = ? and rank = 1";
        String[] selectionArgs = new String[]{this.userId, providerId};
        List<Connection<?>> connections = this.queryForConnections(sql, selectionArgs);
        if (connections.size() > 0) {
            return connections.get(0);
        }
        return null;
    }

    private <A> String getProviderId(Class<A> apiType) {
        return this.connectionFactoryLocator.getConnectionFactory(apiType).getProviderId();
    }

    private String encrypt(String text) {
        return text != null ? this.textEncryptor.encrypt(text) : text;
    }

    private String decrypt(String encryptedText) {
        return encryptedText != null ? this.textEncryptor.decrypt(encryptedText) : encryptedText;
    }

    private Long expireTime(long expireTime) {
        return expireTime == 0L ? null : Long.valueOf(expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection<?> queryForConnection(String sql, String[] selectionArgs) {
        SQLiteDatabase db = this.repositoryHelper.getReadableDatabase();
        Cursor c = null;
        Connection<?> connection = null;
        try {
            c = db.rawQuery(sql, selectionArgs);
            if (c.getCount() > 0) {
                c.moveToFirst();
                connection = this.mapConnectionRow(c);
            }
        }
        finally {
            c.close();
            db.close();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection<?>> queryForConnections(String sql, String[] selectionArgs) {
        SQLiteDatabase db = this.repositoryHelper.getReadableDatabase();
        Cursor c = null;
        ArrayList connections = new ArrayList();
        try {
            c = db.rawQuery(sql, selectionArgs);
            c.moveToFirst();
            for (int i = 0; i < c.getCount(); ++i) {
                connections.add(this.mapConnectionRow(c));
                c.moveToNext();
            }
        }
        finally {
            c.close();
            db.close();
        }
        return connections;
    }

    private Connection<?> mapConnectionRow(Cursor c) {
        ConnectionData connectionData = this.mapConnectionData(c);
        ConnectionFactory connectionFactory = this.connectionFactoryLocator.getConnectionFactory(connectionData.getProviderId());
        return connectionFactory.createConnection(connectionData);
    }

    private ConnectionData mapConnectionData(Cursor c) {
        return new ConnectionData(c.getString(c.getColumnIndex("providerId")), c.getString(c.getColumnIndex("providerUserId")), c.getString(c.getColumnIndex("displayName")), c.getString(c.getColumnIndex("profileUrl")), c.getString(c.getColumnIndex("imageUrl")), this.decrypt(c.getString(c.getColumnIndex("accessToken"))), this.decrypt(c.getString(c.getColumnIndex("secret"))), this.decrypt(c.getString(c.getColumnIndex("refreshToken"))), this.expireTime(c.getLong(c.getColumnIndex("expireTime"))));
    }
}

