/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.connect.sqlite;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactoryLocator;
import org.springframework.social.connect.ConnectionKey;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.ConnectionSignUp;
import org.springframework.social.connect.UsersConnectionRepository;
import org.springframework.social.connect.sqlite.SQLiteConnectionRepository;

public class SQLiteUsersConnectionRepository
implements UsersConnectionRepository {
    private final SQLiteOpenHelper repositoryHelper;
    private final ConnectionFactoryLocator connectionFactoryLocator;
    private final TextEncryptor textEncryptor;
    private ConnectionSignUp connectionSignUp;

    public SQLiteUsersConnectionRepository(SQLiteOpenHelper repositoryHelper, ConnectionFactoryLocator connectionFactoryLocator, TextEncryptor textEncryptor) {
        this.repositoryHelper = repositoryHelper;
        this.connectionFactoryLocator = connectionFactoryLocator;
        this.textEncryptor = textEncryptor;
    }

    public void setConnectionSignUp(ConnectionSignUp connectionSignUp) {
        this.connectionSignUp = connectionSignUp;
    }

    public List<String> findUserIdsWithConnection(Connection<?> connection) {
        String newUserId;
        ConnectionKey key = connection.getKey();
        String sql = "select userId from UserConnection where providerId = ? and providerUserId = ?";
        String[] selectionArgs = new String[]{key.getProviderId(), key.getProviderUserId()};
        SQLiteDatabase db = this.repositoryHelper.getReadableDatabase();
        Cursor c = db.rawQuery("select userId from UserConnection where providerId = ? and providerUserId = ?", selectionArgs);
        ArrayList<String> localUserIds = new ArrayList<String>();
        c.moveToFirst();
        for (int i = 0; i < c.getCount(); ++i) {
            localUserIds.add(c.getString(c.getColumnIndex("userId")));
            c.moveToNext();
        }
        c.close();
        db.close();
        if (localUserIds.size() == 0 && this.connectionSignUp != null && (newUserId = this.connectionSignUp.execute(connection)) != null) {
            this.createConnectionRepository(newUserId).addConnection(connection);
            return Arrays.asList(newUserId);
        }
        return localUserIds;
    }

    public Set<String> findUserIdsConnectedTo(String providerId, Set<String> providerUserIds) {
        StringBuilder providerUserIdsCriteriaSql = new StringBuilder();
        providerUserIdsCriteriaSql.append("(");
        ArrayList<String> args = new ArrayList<String>(1 + providerUserIds.size());
        args.add(providerId);
        Iterator<String> ids = providerUserIds.iterator();
        while (ids.hasNext()) {
            args.add(ids.next());
            providerUserIdsCriteriaSql.append("?");
            if (!ids.hasNext()) continue;
            providerUserIdsCriteriaSql.append(", ");
        }
        providerUserIdsCriteriaSql.append(")");
        String sql = "select userId from UserConnection where providerId = ? and providerUserId in " + providerUserIdsCriteriaSql;
        String[] selectionArgs = args.toArray(new String[0]);
        SQLiteDatabase db = this.repositoryHelper.getReadableDatabase();
        Cursor c = db.rawQuery(sql, selectionArgs);
        HashSet<String> userIds = new HashSet<String>();
        c.moveToFirst();
        for (int i = 0; i < c.getCount(); ++i) {
            userIds.add(c.getString(c.getColumnIndex("userId")));
            c.moveToNext();
        }
        c.close();
        db.close();
        return userIds;
    }

    public ConnectionRepository createConnectionRepository(String userId) {
        if (userId == null) {
            throw new IllegalArgumentException("userId cannot be null");
        }
        return new SQLiteConnectionRepository(userId, this.repositoryHelper, this.connectionFactoryLocator, this.textEncryptor);
    }
}

