/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import org.springframework.http.HttpAuthentication;
import org.springframework.util.Base64Utils;

public class HttpBasicAuthentication
extends HttpAuthentication {
    private final String username;
    private final String password;

    public HttpBasicAuthentication(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public String getHeaderValue() {
        byte[] bytes = String.format("%s:%s", this.username, this.password).getBytes();
        return String.format("Basic %s", Base64Utils.encodeToString((byte[])bytes));
    }

    public String toString() {
        String s = null;
        try {
            s = String.format("Authorization: %s", this.getHeaderValue());
        }
        catch (RuntimeException re) {
            return null;
        }
        return s;
    }
}

