/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.feed;

import android.os.Build;
import com.google.code.rome.android.repackaged.com.sun.syndication.feed.synd.SyndFeed;
import com.google.code.rome.android.repackaged.com.sun.syndication.io.FeedException;
import com.google.code.rome.android.repackaged.com.sun.syndication.io.SyndFeedInput;
import com.google.code.rome.android.repackaged.com.sun.syndication.io.SyndFeedOutput;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.StringUtils;

public class SyndFeedHttpMessageConverter
extends AbstractHttpMessageConverter<SyndFeed> {
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public SyndFeedHttpMessageConverter() {
        super(MediaType.APPLICATION_RSS_XML, MediaType.APPLICATION_ATOM_XML);
        if (Build.VERSION.SDK_INT < 8) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        }
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return SyndFeed.class.isAssignableFrom(clazz);
    }

    @Override
    protected SyndFeed readInternal(Class<? extends SyndFeed> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        SyndFeedInput feedInput = new SyndFeedInput();
        MediaType contentType = inputMessage.getHeaders().getContentType();
        Charset charset = contentType != null && contentType.getCharSet() != null ? contentType.getCharSet() : DEFAULT_CHARSET;
        try {
            InputStreamReader reader = new InputStreamReader(inputMessage.getBody(), charset);
            return feedInput.build((Reader)reader);
        }
        catch (FeedException ex) {
            throw new HttpMessageNotReadableException("Could not read SyndFeed: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void writeInternal(SyndFeed syndFeed, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        MediaType contentType;
        String syndFeedEncoding = syndFeed.getEncoding();
        if (!StringUtils.hasLength((String)syndFeedEncoding)) {
            syndFeedEncoding = DEFAULT_CHARSET.name();
        }
        if ((contentType = outputMessage.getHeaders().getContentType()) != null) {
            Charset syndFeedCharset = Charset.forName(syndFeedEncoding);
            contentType = new MediaType(contentType.getType(), contentType.getSubtype(), syndFeedCharset);
            outputMessage.getHeaders().setContentType(contentType);
        }
        SyndFeedOutput feedOutput = new SyndFeedOutput();
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), syndFeedEncoding);
            feedOutput.output(syndFeed, (Writer)writer);
        }
        catch (FeedException ex) {
            throw new HttpMessageNotWritableException("Could not write SyndFeed: " + ex.getMessage(), ex);
        }
    }
}

