/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.springframework.http.ContentCodingType;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;

public abstract class AbstractClientHttpResponse
implements ClientHttpResponse {
    private InputStream compressedBody;

    public HttpStatus getStatusCode() throws IOException {
        return HttpStatus.valueOf(this.getRawStatusCode());
    }

    public InputStream getBody() throws IOException {
        InputStream body = this.getBodyInternal();
        if (this.isCompressed()) {
            return this.getCompressedBody(body);
        }
        return body;
    }

    public void close() {
        if (this.compressedBody != null) {
            try {
                this.compressedBody.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.closeInternal();
    }

    private boolean isCompressed() {
        List<ContentCodingType> contentCodingTypes = this.getHeaders().getContentEncoding();
        for (ContentCodingType contentCodingType : contentCodingTypes) {
            if (!contentCodingType.equals(ContentCodingType.GZIP)) continue;
            return true;
        }
        return false;
    }

    private InputStream getCompressedBody(InputStream body) throws IOException {
        if (this.compressedBody == null) {
            this.compressedBody = new GZIPInputStream(body);
        }
        return this.compressedBody;
    }

    protected abstract InputStream getBodyInternal() throws IOException;

    protected abstract void closeInternal();
}

