/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.springframework.http.InvalidMediaTypeException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.util.StringUtils;
import org.springframework.util.comparator.CompoundComparator;

public class MediaType
implements Comparable<MediaType> {
    public static final MediaType ALL;
    public static final String ALL_VALUE = "*/*";
    public static final MediaType APPLICATION_ATOM_XML;
    public static final String APPLICATION_ATOM_XML_VALUE = "application/atom+xml";
    public static final MediaType APPLICATION_RSS_XML;
    public static final String APPLICATION_RSS_XML_VALUE = "application/rss+xml";
    public static final MediaType APPLICATION_FORM_URLENCODED;
    public static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    public static final MediaType APPLICATION_JSON;
    public static final String APPLICATION_JSON_VALUE = "application/json";
    public static final MediaType APPLICATION_OCTET_STREAM;
    public static final String APPLICATION_OCTET_STREAM_VALUE = "application/octet-stream";
    public static final MediaType APPLICATION_XHTML_XML;
    public static final String APPLICATION_XHTML_XML_VALUE = "application/xhtml+xml";
    public static final MediaType APPLICATION_XML;
    public static final String APPLICATION_XML_VALUE = "application/xml";
    public static final MediaType APPLICATION_WILDCARD_XML;
    public static final String APPLICATION_WILDCARD_XML_VALUE = "application/*+xml";
    public static final MediaType IMAGE_GIF;
    public static final String IMAGE_GIF_VALUE = "image/gif";
    public static final MediaType IMAGE_JPEG;
    public static final String IMAGE_JPEG_VALUE = "image/jpeg";
    public static final MediaType IMAGE_PNG;
    public static final String IMAGE_PNG_VALUE = "image/png";
    public static final MediaType MULTIPART_FORM_DATA;
    public static final String MULTIPART_FORM_DATA_VALUE = "multipart/form-data";
    public static final MediaType TEXT_HTML;
    public static final String TEXT_HTML_VALUE = "text/html";
    public static final MediaType TEXT_PLAIN;
    public static final String TEXT_PLAIN_VALUE = "text/plain";
    public static final MediaType TEXT_XML;
    public static final String TEXT_XML_VALUE = "text/xml";
    private static final BitSet TOKEN;
    private static final String WILDCARD_TYPE = "*";
    private static final String PARAM_QUALITY_FACTOR = "q";
    private static final String PARAM_CHARSET = "charset";
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    public static final Comparator<MediaType> SPECIFICITY_COMPARATOR;
    public static final Comparator<MediaType> QUALITY_VALUE_COMPARATOR;

    public MediaType(String type) {
        this(type, WILDCARD_TYPE);
    }

    public MediaType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    public MediaType(String type, String subtype, Charset charset) {
        this(type, subtype, Collections.singletonMap(PARAM_CHARSET, charset.name()));
    }

    public MediaType(String type, String subtype, double qualityValue) {
        this(type, subtype, Collections.singletonMap(PARAM_QUALITY_FACTOR, Double.toString(qualityValue)));
    }

    public MediaType(MediaType other, Map<String, String> parameters) {
        this(other.getType(), other.getSubtype(), parameters);
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        Assert.hasLength((String)type, (String)"type must not be empty");
        Assert.hasLength((String)subtype, (String)"subtype must not be empty");
        this.checkToken(type);
        this.checkToken(subtype);
        this.type = type.toLowerCase(Locale.ENGLISH);
        this.subtype = subtype.toLowerCase(Locale.ENGLISH);
        if (!CollectionUtils.isEmpty(parameters)) {
            LinkedCaseInsensitiveMap m = new LinkedCaseInsensitiveMap(parameters.size(), Locale.ENGLISH);
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                String attribute = entry.getKey();
                String value = entry.getValue();
                this.checkParameters(attribute, value);
                m.put(attribute, value);
            }
            this.parameters = Collections.unmodifiableMap(m);
        } else {
            this.parameters = Collections.emptyMap();
        }
    }

    private void checkToken(String token) {
        for (int i = 0; i < token.length(); ++i) {
            char ch = token.charAt(i);
            if (TOKEN.get(ch)) continue;
            throw new IllegalArgumentException("Invalid token character '" + ch + "' in token \"" + token + "\"");
        }
    }

    private void checkParameters(String attribute, String value) {
        Assert.hasLength((String)attribute, (String)"parameter attribute must not be empty");
        Assert.hasLength((String)value, (String)"parameter value must not be empty");
        this.checkToken(attribute);
        if (PARAM_QUALITY_FACTOR.equals(attribute)) {
            double d = Double.parseDouble(value = this.unquote(value));
            Assert.isTrue((d >= 0.0 && d <= 1.0 ? 1 : 0) != 0, (String)("Invalid quality value \"" + value + "\": should be between 0.0 and 1.0"));
        } else if (PARAM_CHARSET.equals(attribute)) {
            value = this.unquote(value);
            Charset.forName(value);
        } else if (!this.isQuotedString(value)) {
            this.checkToken(value);
        }
    }

    private boolean isQuotedString(String s) {
        if (s.length() < 2) {
            return false;
        }
        return s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'");
    }

    private String unquote(String s) {
        if (s == null) {
            return null;
        }
        return this.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return WILDCARD_TYPE.equals(this.type);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return WILDCARD_TYPE.equals(this.subtype) || this.subtype.startsWith("*+");
    }

    public boolean isConcrete() {
        return !this.isWildcardType() && !this.isWildcardSubtype();
    }

    public Charset getCharSet() {
        String charSet = this.getParameter(PARAM_CHARSET);
        return charSet != null ? Charset.forName(this.unquote(charSet)) : null;
    }

    public double getQualityValue() {
        String qualityFactory = this.getParameter(PARAM_QUALITY_FACTOR);
        return qualityFactory != null ? Double.parseDouble(this.unquote(qualityFactory)) : 1.0;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean includes(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType()) {
            return true;
        }
        if (this.type.equals(other.type)) {
            if (this.subtype.equals(other.subtype)) {
                return true;
            }
            if (this.isWildcardSubtype()) {
                int thisPlusIdx = this.subtype.indexOf(43);
                if (thisPlusIdx == -1) {
                    return true;
                }
                int otherPlusIdx = other.subtype.indexOf(43);
                if (otherPlusIdx != -1) {
                    String otherSubtypeSuffix;
                    String thisSubtypeNoSuffix = this.subtype.substring(0, thisPlusIdx);
                    String thisSubtypeSuffix = this.subtype.substring(thisPlusIdx + 1);
                    if (thisSubtypeSuffix.equals(otherSubtypeSuffix = other.subtype.substring(otherPlusIdx + 1)) && WILDCARD_TYPE.equals(thisSubtypeNoSuffix)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isCompatibleWith(MediaType other) {
        if (other == null) {
            return false;
        }
        if (this.isWildcardType() || other.isWildcardType()) {
            return true;
        }
        if (this.type.equals(other.type)) {
            if (this.subtype.equals(other.subtype)) {
                return true;
            }
            if (this.isWildcardSubtype() || other.isWildcardSubtype()) {
                int thisPlusIdx = this.subtype.indexOf(43);
                int otherPlusIdx = other.subtype.indexOf(43);
                if (thisPlusIdx == -1 && otherPlusIdx == -1) {
                    return true;
                }
                if (thisPlusIdx != -1 && otherPlusIdx != -1) {
                    String otherSubtypeSuffix;
                    String thisSubtypeNoSuffix = this.subtype.substring(0, thisPlusIdx);
                    String otherSubtypeNoSuffix = other.subtype.substring(0, otherPlusIdx);
                    String thisSubtypeSuffix = this.subtype.substring(thisPlusIdx + 1);
                    if (thisSubtypeSuffix.equals(otherSubtypeSuffix = other.subtype.substring(otherPlusIdx + 1)) && (WILDCARD_TYPE.equals(thisSubtypeNoSuffix) || WILDCARD_TYPE.equals(otherSubtypeNoSuffix))) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public MediaType copyQualityValue(MediaType mediaType) {
        if (!mediaType.parameters.containsKey(PARAM_QUALITY_FACTOR)) {
            return this;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.parameters);
        params.put(PARAM_QUALITY_FACTOR, mediaType.parameters.get(PARAM_QUALITY_FACTOR));
        return new MediaType(this, params);
    }

    public MediaType removeQualityValue() {
        if (!this.parameters.containsKey(PARAM_QUALITY_FACTOR)) {
            return this;
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(this.parameters);
        params.remove(PARAM_QUALITY_FACTOR);
        return new MediaType(this, params);
    }

    @Override
    public int compareTo(MediaType other) {
        int comp = this.type.compareToIgnoreCase(other.type);
        if (comp != 0) {
            return comp;
        }
        comp = this.subtype.compareToIgnoreCase(other.subtype);
        if (comp != 0) {
            return comp;
        }
        comp = this.parameters.size() - other.parameters.size();
        if (comp != 0) {
            return comp;
        }
        TreeSet<String> thisAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        thisAttributes.addAll(this.parameters.keySet());
        TreeSet<String> otherAttributes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        otherAttributes.addAll(other.parameters.keySet());
        Iterator thisAttributesIterator = thisAttributes.iterator();
        Iterator otherAttributesIterator = otherAttributes.iterator();
        while (thisAttributesIterator.hasNext()) {
            String otherAttribute;
            String thisAttribute = (String)thisAttributesIterator.next();
            comp = thisAttribute.compareToIgnoreCase(otherAttribute = (String)otherAttributesIterator.next());
            if (comp != 0) {
                return comp;
            }
            String thisValue = this.parameters.get(thisAttribute);
            String otherValue = other.parameters.get(otherAttribute);
            if (otherValue == null) {
                otherValue = "";
            }
            if ((comp = thisValue.compareTo(otherValue)) == 0) continue;
            return comp;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaType)) {
            return false;
        }
        MediaType otherType = (MediaType)other;
        return this.type.equalsIgnoreCase(otherType.type) && this.subtype.equalsIgnoreCase(otherType.subtype) && ((Object)this.parameters).equals(otherType.parameters);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + ((Object)this.parameters).hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    private void appendTo(StringBuilder builder) {
        builder.append(this.type);
        builder.append('/');
        builder.append(this.subtype);
        this.appendTo(this.parameters, builder);
    }

    private void appendTo(Map<String, String> map, StringBuilder builder) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.append(';');
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
    }

    public static MediaType valueOf(String value) {
        return MediaType.parseMediaType(value);
    }

    public static MediaType parseMediaType(String mediaType) {
        int subIndex;
        Assert.hasLength((String)mediaType, (String)"'mediaType' must not be empty");
        String[] parts = StringUtils.tokenizeToStringArray((String)mediaType, (String)";");
        String fullType = parts[0].trim();
        if (WILDCARD_TYPE.equals(fullType)) {
            fullType = ALL_VALUE;
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new InvalidMediaTypeException(mediaType, "does not contain '/'");
        }
        if (subIndex == fullType.length() - 1) {
            throw new InvalidMediaTypeException(mediaType, "does not contain subtype after '/'");
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1, fullType.length());
        if (WILDCARD_TYPE.equals(type) && !WILDCARD_TYPE.equals(subtype)) {
            throw new InvalidMediaTypeException(mediaType, "wildcard type is legal only in '*/*' (all media types)");
        }
        LinkedHashMap<String, String> parameters = null;
        if (parts.length > 1) {
            parameters = new LinkedHashMap<String, String>(parts.length - 1);
            for (int i = 1; i < parts.length; ++i) {
                String parameter = parts[i];
                int eqIndex = parameter.indexOf(61);
                if (eqIndex == -1) continue;
                String attribute = parameter.substring(0, eqIndex);
                String value = parameter.substring(eqIndex + 1, parameter.length());
                parameters.put(attribute, value);
            }
        }
        try {
            return new MediaType(type, subtype, parameters);
        }
        catch (UnsupportedCharsetException ex) {
            throw new InvalidMediaTypeException(mediaType, "unsupported charset '" + ex.getCharsetName() + "'");
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidMediaTypeException(mediaType, ex.getMessage());
        }
    }

    public static List<MediaType> parseMediaTypes(String mediaTypes) {
        if (!StringUtils.hasLength((String)mediaTypes)) {
            return Collections.emptyList();
        }
        String[] tokens = mediaTypes.split(",\\s*");
        ArrayList<MediaType> result = new ArrayList<MediaType>(tokens.length);
        for (String token : tokens) {
            result.add(MediaType.parseMediaType(token));
        }
        return result;
    }

    public static String toString(Collection<MediaType> mediaTypes) {
        StringBuilder builder = new StringBuilder();
        Iterator<MediaType> iterator = mediaTypes.iterator();
        while (iterator.hasNext()) {
            MediaType mediaType = iterator.next();
            mediaType.appendTo(builder);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public static void sortBySpecificity(List<MediaType> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"'mediaTypes' must not be null");
        if (mediaTypes.size() > 1) {
            Collections.sort(mediaTypes, SPECIFICITY_COMPARATOR);
        }
    }

    public static void sortByQualityValue(List<MediaType> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"'mediaTypes' must not be null");
        if (mediaTypes.size() > 1) {
            Collections.sort(mediaTypes, QUALITY_VALUE_COMPARATOR);
        }
    }

    public static void sortBySpecificityAndQuality(List<MediaType> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"'mediaTypes' must not be null");
        if (mediaTypes.size() > 1) {
            Collections.sort(mediaTypes, new CompoundComparator(new Comparator[]{SPECIFICITY_COMPARATOR, QUALITY_VALUE_COMPARATOR}));
        }
    }

    static {
        BitSet ctl = new BitSet(128);
        for (int i = 0; i <= 31; ++i) {
            ctl.set(i);
        }
        ctl.set(127);
        BitSet separators = new BitSet(128);
        separators.set(40);
        separators.set(41);
        separators.set(60);
        separators.set(62);
        separators.set(64);
        separators.set(44);
        separators.set(59);
        separators.set(58);
        separators.set(92);
        separators.set(34);
        separators.set(47);
        separators.set(91);
        separators.set(93);
        separators.set(63);
        separators.set(61);
        separators.set(123);
        separators.set(125);
        separators.set(32);
        separators.set(9);
        TOKEN = new BitSet(128);
        TOKEN.set(0, 128);
        TOKEN.andNot(ctl);
        TOKEN.andNot(separators);
        ALL = MediaType.valueOf(ALL_VALUE);
        APPLICATION_ATOM_XML = MediaType.valueOf(APPLICATION_ATOM_XML_VALUE);
        APPLICATION_RSS_XML = MediaType.valueOf(APPLICATION_RSS_XML_VALUE);
        APPLICATION_FORM_URLENCODED = MediaType.valueOf(APPLICATION_FORM_URLENCODED_VALUE);
        APPLICATION_JSON = MediaType.valueOf(APPLICATION_JSON_VALUE);
        APPLICATION_OCTET_STREAM = MediaType.valueOf(APPLICATION_OCTET_STREAM_VALUE);
        APPLICATION_XHTML_XML = MediaType.valueOf(APPLICATION_XHTML_XML_VALUE);
        APPLICATION_XML = MediaType.valueOf(APPLICATION_XML_VALUE);
        APPLICATION_WILDCARD_XML = MediaType.valueOf(APPLICATION_WILDCARD_XML_VALUE);
        IMAGE_GIF = MediaType.valueOf(IMAGE_GIF_VALUE);
        IMAGE_JPEG = MediaType.valueOf(IMAGE_JPEG_VALUE);
        IMAGE_PNG = MediaType.valueOf(IMAGE_PNG_VALUE);
        MULTIPART_FORM_DATA = MediaType.valueOf(MULTIPART_FORM_DATA_VALUE);
        TEXT_HTML = MediaType.valueOf(TEXT_HTML_VALUE);
        TEXT_PLAIN = MediaType.valueOf(TEXT_PLAIN_VALUE);
        TEXT_XML = MediaType.valueOf(TEXT_XML_VALUE);
        SPECIFICITY_COMPARATOR = new Comparator<MediaType>(){

            @Override
            public int compare(MediaType mediaType1, MediaType mediaType2) {
                if (mediaType1.isWildcardType() && !mediaType2.isWildcardType()) {
                    return 1;
                }
                if (mediaType2.isWildcardType() && !mediaType1.isWildcardType()) {
                    return -1;
                }
                if (!mediaType1.getType().equals(mediaType2.getType())) {
                    return 0;
                }
                if (mediaType1.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
                    return 1;
                }
                if (mediaType2.isWildcardSubtype() && !mediaType1.isWildcardSubtype()) {
                    return -1;
                }
                if (!mediaType1.getSubtype().equals(mediaType2.getSubtype())) {
                    return 0;
                }
                double quality1 = mediaType1.getQualityValue();
                double quality2 = mediaType2.getQualityValue();
                int qualityComparison = Double.compare(quality2, quality1);
                if (qualityComparison != 0) {
                    return qualityComparison;
                }
                int paramsSize1 = mediaType1.parameters.size();
                int paramsSize2 = mediaType2.parameters.size();
                return paramsSize2 < paramsSize1 ? -1 : (paramsSize2 == paramsSize1 ? 0 : 1);
            }
        };
        QUALITY_VALUE_COMPARATOR = new Comparator<MediaType>(){

            @Override
            public int compare(MediaType mediaType1, MediaType mediaType2) {
                double quality1 = mediaType1.getQualityValue();
                double quality2 = mediaType2.getQualityValue();
                int qualityComparison = Double.compare(quality2, quality1);
                if (qualityComparison != 0) {
                    return qualityComparison;
                }
                if (mediaType1.isWildcardType() && !mediaType2.isWildcardType()) {
                    return 1;
                }
                if (mediaType2.isWildcardType() && !mediaType1.isWildcardType()) {
                    return -1;
                }
                if (!mediaType1.getType().equals(mediaType2.getType())) {
                    return 0;
                }
                if (mediaType1.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
                    return 1;
                }
                if (mediaType2.isWildcardSubtype() && !mediaType1.isWildcardSubtype()) {
                    return -1;
                }
                if (!mediaType1.getSubtype().equals(mediaType2.getSubtype())) {
                    return 0;
                }
                int paramsSize1 = mediaType1.parameters.size();
                int paramsSize2 = mediaType2.parameters.size();
                return paramsSize2 < paramsSize1 ? -1 : (paramsSize2 == paramsSize1 ? 0 : 1);
            }
        };
    }
}

