/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.batch.core.StepExecution;

public class StepExecutionInfo {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private Long id;
    private Long jobExecutionId;
    private String jobName;
    private String name;
    private String startDate = "-";
    private String startTime = "-";
    private String duration = "-";
    private StepExecution stepExecution;
    private long durationMillis;

    public StepExecutionInfo(StepExecution stepExecution, TimeZone timeZone) {
        this.stepExecution = stepExecution;
        this.id = stepExecution.getId();
        this.name = stepExecution.getStepName();
        this.jobName = stepExecution.getJobExecution() == null || stepExecution.getJobExecution().getJobInstance() == null ? "?" : stepExecution.getJobExecution().getJobInstance().getJobName();
        this.jobExecutionId = stepExecution.getJobExecutionId();
        this.timeFormat.setTimeZone(timeZone);
        if (stepExecution.getStartTime() != null) {
            this.startDate = this.dateFormat.format(stepExecution.getStartTime());
            this.startTime = this.timeFormat.format(stepExecution.getStartTime());
            Date endTime = stepExecution.getEndTime() != null ? stepExecution.getEndTime() : new Date();
            this.durationMillis = endTime.getTime() - stepExecution.getStartTime().getTime();
            this.duration = this.timeFormat.format(new Date(this.durationMillis));
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public String getName() {
        return this.name;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public long getDurationMillis() {
        return this.durationMillis;
    }

    public StepExecution getStepExecution() {
        return this.stepExecution;
    }
}

