/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.history;

import java.util.Date;
import org.springframework.batch.admin.history.CumulativeHistory;
import org.springframework.batch.core.JobExecution;

public class JobExecutionHistory {
    private final String jobName;
    private CumulativeHistory duration = new CumulativeHistory();

    public JobExecutionHistory(String jobName) {
        this.jobName = jobName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public CumulativeHistory getDuration() {
        return this.duration;
    }

    public void append(JobExecution jobExecution) {
        if (jobExecution.getEndTime() == null) {
            return;
        }
        Date startTime = jobExecution.getStartTime();
        Date endTime = jobExecution.getEndTime();
        long time = endTime.getTime() - startTime.getTime();
        this.duration.append(time);
    }
}

