/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.jmx;

import java.util.Collection;
import java.util.Date;
import org.springframework.batch.admin.domain.JobExecutionHistory;
import org.springframework.batch.admin.jmx.JobExecutionMetrics;
import org.springframework.batch.admin.service.JobService;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource
public class SimpleJobExecutionMetrics
implements JobExecutionMetrics {
    private final JobService jobService;
    private final String jobName;

    public SimpleJobExecutionMetrics(JobService jobService, String jobName) {
        this.jobService = jobService;
        this.jobName = jobName;
    }

    @Override
    public int getExecutionCount() {
        try {
            return this.jobService.countJobExecutionsForJob(this.jobName);
        }
        catch (NoSuchJobException e) {
            throw new IllegalStateException("Cannot locate job=" + this.jobName, e);
        }
    }

    @Override
    public int getFailureCount() {
        Collection<JobExecution> jobExecutions;
        int pageSize = 100;
        int start = 0;
        int count = 0;
        do {
            try {
                jobExecutions = this.jobService.listJobExecutionsForJob(this.jobName, start, pageSize);
                start += pageSize;
            }
            catch (NoSuchJobException e) {
                throw new IllegalStateException("Cannot locate job=" + this.jobName, e);
            }
            for (JobExecution jobExecution : jobExecutions) {
                if (!jobExecution.getStatus().isUnsuccessful()) continue;
                ++count;
            }
        } while (!jobExecutions.isEmpty());
        return count;
    }

    @Override
    public double getLatestDuration() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        JobExecutionHistory history = new JobExecutionHistory(this.jobName);
        history.append(jobExecution);
        return history.getDuration().getMean();
    }

    @Override
    public double getMeanDuration() {
        JobExecutionHistory history = this.computeHistory(this.jobName);
        return history.getDuration().getMean();
    }

    @Override
    public double getMaxDuration() {
        JobExecutionHistory history = this.computeHistory(this.jobName);
        return history.getDuration().getMax();
    }

    @Override
    public Date getLatestStartTime() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        return jobExecution == null ? null : jobExecution.getStartTime();
    }

    @Override
    public Date getLatestEndTime() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        return jobExecution == null ? null : jobExecution.getEndTime();
    }

    @Override
    public String getLatestExitCode() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        return jobExecution == null ? "NONE" : jobExecution.getExitStatus().getExitCode();
    }

    @Override
    public String getLatestStatus() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        return jobExecution == null ? "NONE" : jobExecution.getStatus().toString();
    }

    @Override
    public long getLatestExecutionId() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        return jobExecution == null ? -1L : jobExecution.getId();
    }

    @Override
    public String getLatestStepExitDescription() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        StepExecution stepExecution = this.getLatestStepExecution(jobExecution);
        return stepExecution == null ? "" : stepExecution.getExitStatus().getExitDescription();
    }

    @Override
    public String getLatestStepName() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        StepExecution stepExecution = this.getLatestStepExecution(jobExecution);
        return stepExecution == null ? "" : stepExecution.getStepName();
    }

    @Override
    public boolean isJobRunning() {
        JobExecution jobExecution = this.getLatestJobExecution(this.jobName);
        return jobExecution == null ? false : jobExecution.isRunning();
    }

    private JobExecutionHistory computeHistory(String jobName) {
        return this.computeHistory(jobName, 10);
    }

    private JobExecution getLatestJobExecution(String jobName) {
        try {
            Collection<JobExecution> jobExecutions = this.jobService.listJobExecutionsForJob(jobName, 0, 4);
            if (jobExecutions.isEmpty()) {
                return null;
            }
            long lastUpdated = 0L;
            JobExecution result = null;
            for (JobExecution jobExecution : jobExecutions) {
                long updated = jobExecution.getCreateTime().getTime();
                if (updated > lastUpdated) {
                    result = jobExecution;
                    lastUpdated = updated;
                    continue;
                }
                if (result == null || updated != lastUpdated || jobExecution.getId() <= result.getId()) continue;
                result = jobExecution;
            }
            return result;
        }
        catch (NoSuchJobException e) {
            throw new IllegalStateException("Cannot locate job=" + jobName, e);
        }
    }

    private StepExecution getLatestStepExecution(JobExecution jobExecution) {
        Collection stepExecutions = jobExecution.getStepExecutions();
        StepExecution stepExecution = null;
        if (!stepExecutions.isEmpty()) {
            Date latest = new Date(0L);
            for (StepExecution candidate : stepExecutions) {
                Date stepDate = candidate.getEndTime();
                Date date = stepDate = stepDate == null ? new Date() : stepDate;
                if (stepDate.after(latest)) {
                    latest = stepDate;
                    stepExecution = candidate;
                    continue;
                }
                if (stepExecution == null || !stepDate.equals(latest) || candidate.getId() <= stepExecution.getId()) continue;
                stepExecution = candidate;
            }
        }
        return stepExecution;
    }

    private JobExecutionHistory computeHistory(String jobName, int total) {
        JobExecutionHistory jobExecutionHistory = new JobExecutionHistory(jobName);
        try {
            for (JobExecution jobExecution : this.jobService.listJobExecutionsForJob(jobName, 0, total)) {
                jobExecutionHistory.append(jobExecution);
            }
        }
        catch (NoSuchJobException e) {
            throw new IllegalStateException("Cannot locate job=" + jobName, e);
        }
        return jobExecutionHistory;
    }
}

