/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.jmx;

import javax.management.ObjectName;
import javax.management.monitor.GaugeMonitor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class StepExecutionServiceLevelMonitor
implements FactoryBean<GaugeMonitor>,
InitializingBean {
    private String defaultDomain = "org.springframework.batch";
    private String stepName;
    private String jobName;
    private int upperThreshold = 0;
    private int lowerThreshold = 0;
    private boolean autoStart = true;
    private String observedAttribute = "LatestDuration";

    public void setObservedAttribute(String observedAttribute) {
        this.observedAttribute = observedAttribute;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public void setUpperThreshold(int upperThreshold) {
        this.upperThreshold = upperThreshold;
    }

    public void setLowerThreshold(int lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
    }

    public GaugeMonitor getObject() throws Exception {
        GaugeMonitor monitor = new GaugeMonitor();
        monitor.setNotifyHigh(true);
        monitor.addObservedObject(new ObjectName(String.format("%s:type=JobExecution,name=%s,step=%s", this.defaultDomain, this.jobName, this.stepName)));
        monitor.setObservedAttribute(this.observedAttribute);
        if (this.observedAttribute.endsWith("Duration")) {
            monitor.setThresholds(new Double(this.upperThreshold), new Double(this.lowerThreshold));
        } else {
            monitor.setThresholds(new Integer(this.upperThreshold), new Integer(this.lowerThreshold));
        }
        if (this.autoStart) {
            monitor.start();
        }
        return monitor;
    }

    public Class<?> getObjectType() {
        return GaugeMonitor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.jobName != null ? 1 : 0) != 0, (String)"A Job name must be provided");
        Assert.state((this.stepName != null ? 1 : 0) != 0, (String)"A Step name must be provided");
        Assert.state((this.upperThreshold > 0 ? 1 : 0) != 0, (String)"A threshold must be provided");
        Assert.state((this.lowerThreshold < this.upperThreshold ? 1 : 0) != 0, (String)"A threshold must be provided");
        if (this.lowerThreshold == 0) {
            this.lowerThreshold = this.upperThreshold * 8 / 10;
        }
    }
}

