/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.service;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.step.NoSuchStepException;
import org.springframework.batch.core.step.StepLocator;

public class JobLocatorStepLocator
implements StepLocator {
    private ListableJobLocator jobLocator;

    public JobLocatorStepLocator(ListableJobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    public JobLocatorStepLocator() {
    }

    public void setJobLocator(ListableJobLocator jobLocator) {
        this.jobLocator = jobLocator;
    }

    public Step getStep(String path) throws NoSuchStepException {
        Job job;
        String jobName = path.substring(0, path.indexOf("/"));
        String stepName = path.substring(jobName.length() + 1);
        try {
            job = this.jobLocator.getJob(jobName);
        }
        catch (NoSuchJobException e) {
            throw new NoSuchStepException("No step could be located because no job was found with name=" + jobName);
        }
        String prefix = jobName + ".";
        if (job instanceof StepLocator) {
            if (((StepLocator)job).getStepNames().contains(stepName)) {
                return ((StepLocator)job).getStep(stepName);
            }
            if (((StepLocator)job).getStepNames().contains(prefix + stepName)) {
                return ((StepLocator)job).getStep(prefix + stepName);
            }
            throw new NoSuchStepException("No step could be located: " + path);
        }
        throw new NoSuchStepException("No step could be located because the job was not a StepLocator.");
    }

    public Collection<String> getStepNames() {
        HashSet<String> result = new HashSet<String>();
        for (String jobName : this.jobLocator.getJobNames()) {
            Job job;
            try {
                job = this.jobLocator.getJob(jobName);
            }
            catch (NoSuchJobException e) {
                throw new IllegalStateException("Job not found although it was listed with name=" + jobName);
            }
            String prefix = jobName + ".";
            if (!(job instanceof StepLocator)) continue;
            for (String stepName : ((StepLocator)job).getStepNames()) {
                if (stepName.startsWith(prefix)) {
                    stepName = stepName.substring(prefix.length());
                }
                result.add(jobName + "/" + stepName);
            }
        }
        return result;
    }
}

