/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.batch.admin.domain.JobExecutionInfo;
import org.springframework.batch.admin.domain.JobExecutionInfoResource;
import org.springframework.batch.admin.domain.NoSuchBatchJobException;
import org.springframework.batch.admin.domain.support.JobParametersExtractor;
import org.springframework.batch.admin.web.AbstractBatchJobsController;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.configuration.ListableJobLocator;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.hateoas.ExposesResourceFor;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/batch/executions"})
@ExposesResourceFor(value=JobExecutionInfoResource.class)
public class BatchJobExecutionsController
extends AbstractBatchJobsController {
    @Autowired
    private ListableJobLocator jobLocator;

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedResources<JobExecutionInfoResource> list(Pageable pageable) throws NoSuchJobException {
        ArrayList<JobExecutionInfoResource> resources = new ArrayList<JobExecutionInfoResource>();
        for (JobExecution jobExecution : this.jobService.listJobExecutions(pageable.getOffset(), pageable.getPageSize())) {
            Job job = this.jobLocator.getJob(jobExecution.getJobInstance().getJobName());
            JobExecutionInfoResource jobExecutionInfoResource = this.getJobExecutionInfoResource(jobExecution, job.isRestartable());
            resources.add(jobExecutionInfoResource);
        }
        return new PagedResources(resources, new PagedResources.PageMetadata((long)pageable.getPageSize(), (long)pageable.getPageNumber(), (long)this.jobService.countJobExecutions()), new Link[0]);
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, params={"jobname"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Collection<JobExecutionInfoResource> executionsForJob(@RequestParam(value="jobname") String jobName, @RequestParam(defaultValue="0") int startJobExecution, @RequestParam(defaultValue="20") int pageSize) {
        ArrayList<JobExecutionInfoResource> result = new ArrayList<JobExecutionInfoResource>();
        try {
            for (JobExecution jobExecution : this.jobService.listJobExecutionsForJob(jobName, startJobExecution, pageSize)) {
                result.add(this.jobExecutionInfoResourceAssembler.toResource(new JobExecutionInfo(jobExecution, this.timeZone)));
            }
        }
        catch (NoSuchJobException e) {
            throw new NoSuchBatchJobException(jobName);
        }
        return result;
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, params={"jobname"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public void launchJob(@RequestParam(value="jobname") String name, @RequestParam(required=false) String jobParameters) throws JobParametersInvalidException, JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, NoSuchJobException {
        JobParameters params = new JobParameters();
        if (jobParameters != null) {
            JobParametersExtractor extractor = new JobParametersExtractor();
            extractor.fromString(jobParameters);
        }
        this.jobService.launch(name, params);
    }

    private Collection<String> getJobDefinitionNames() {
        int totalJobs = this.jobService.countJobs();
        return this.jobService.listJobs(0, totalJobs);
    }

    private boolean isJobExecutionRestartable(JobExecution jobExecution) {
        JobInstance jobInstance = jobExecution.getJobInstance();
        BatchStatus status = jobExecution.getStatus();
        try {
            List jobExecutionsForJobInstance = (List)this.jobService.getJobExecutionsForJobInstance(jobInstance.getJobName(), jobInstance.getId());
            for (JobExecution jobExecutionForJobInstance : jobExecutionsForJobInstance) {
                if (jobExecutionForJobInstance.getStatus() != BatchStatus.COMPLETED) continue;
                return false;
            }
        }
        catch (NoSuchJobException e) {
            throw new NoSuchBatchJobException(jobInstance.getJobName());
        }
        return status.isGreaterThan(BatchStatus.STOPPING) && status.isLessThan(BatchStatus.ABANDONED);
    }

    @RequestMapping(value={"/{executionId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public JobExecutionInfoResource getJobExecutionInfo(@PathVariable long executionId) throws NoSuchJobExecutionException {
        Job job;
        JobExecution jobExecution;
        try {
            jobExecution = this.jobService.getJobExecution(executionId);
        }
        catch (NoSuchJobExecutionException e) {
            throw new NoSuchJobExecutionException(String.format("Could not find jobExecution with id %s", String.valueOf(executionId)));
        }
        String jobName = jobExecution.getJobInstance().getJobName();
        try {
            job = this.jobLocator.getJob(jobName);
        }
        catch (NoSuchJobException e1) {
            throw new NoSuchBatchJobException("The job '" + jobName + "' does not exist.");
        }
        return this.getJobExecutionInfoResource(jobExecution, job.isRestartable());
    }

    private JobExecutionInfoResource getJobExecutionInfoResource(JobExecution jobExecution, boolean restartable) {
        JobExecutionInfoResource jobExecutionInfoResource = this.jobExecutionInfoResourceAssembler.toResource(new JobExecutionInfo(jobExecution, this.timeZone));
        if (restartable) {
            if (jobExecution.getStatus() != BatchStatus.COMPLETED) {
                jobExecutionInfoResource.setRestartable(this.isJobExecutionRestartable(jobExecution));
            }
        } else {
            jobExecutionInfoResource.setRestartable(false);
        }
        return jobExecutionInfoResource;
    }

    @RequestMapping(value={"/{executionId}"}, method={RequestMethod.PUT}, params={"stop=true"})
    @ResponseStatus(value=HttpStatus.OK)
    public void stopJobExecution(@PathVariable(value="executionId") long jobExecutionId) throws JobExecutionNotRunningException, NoSuchJobExecutionException {
        try {
            this.jobService.stop(jobExecutionId);
        }
        catch (JobExecutionNotRunningException e) {
            throw new JobExecutionNotRunningException(String.format("Job execution with executionId %s is not running.", String.valueOf(jobExecutionId)));
        }
        catch (NoSuchJobExecutionException e) {
            throw new NoSuchJobExecutionException(String.format("Could not find jobExecution with id %s", String.valueOf(jobExecutionId)));
        }
    }

    @RequestMapping(value={"/{executionId}"}, method={RequestMethod.PUT}, params={"restart=true"})
    @ResponseStatus(value=HttpStatus.OK)
    public void restartJobExecution(@PathVariable(value="executionId") long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobInstanceAlreadyCompleteException, JobRestartException, NoSuchJobException {
        Job job;
        JobExecution jobExecution;
        try {
            jobExecution = this.jobService.getJobExecution(jobExecutionId);
        }
        catch (NoSuchJobExecutionException e) {
            throw new NoSuchJobExecutionException(String.format("Could not find jobExecution with id %s", String.valueOf(jobExecutionId)));
        }
        if (jobExecution.isRunning()) {
            throw new JobExecutionAlreadyRunningException("Job Execution for this job is already running: " + jobExecution.getJobInstance());
        }
        JobInstance lastInstance = jobExecution.getJobInstance();
        JobParameters jobParameters = jobExecution.getJobParameters();
        try {
            job = this.jobLocator.getJob(lastInstance.getJobName());
        }
        catch (NoSuchJobException e1) {
            throw new NoSuchBatchJobException("The job '" + lastInstance.getJobName() + "' does not exist.");
        }
        try {
            job.getJobParametersValidator().validate(jobParameters);
        }
        catch (JobParametersInvalidException e) {
            throw new JobParametersInvalidException("The Job Parameters for Job Execution " + jobExecution.getId() + " are invalid.");
        }
        BatchStatus status = jobExecution.getStatus();
        if (status == BatchStatus.COMPLETED || status == BatchStatus.ABANDONED) {
            throw new JobInstanceAlreadyCompleteException("Job Execution " + jobExecution.getId() + " is already complete.");
        }
        if (!job.isRestartable()) {
            throw new JobRestartException("The job '" + lastInstance.getJobName() + "' is not restartable.");
        }
        this.jobService.launch(lastInstance.getJobName(), jobParameters);
    }

    @RequestMapping(value={""}, method={RequestMethod.PUT}, params={"stop=true"})
    @ResponseStatus(value=HttpStatus.OK)
    public void stopAll() {
        this.jobService.stopAll();
    }
}

