/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.admin.web;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.integration.http.converter.MultipartAwareFormHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

public class BindingHttpMessageConverter<T>
implements HttpMessageConverter<T>,
BeanFactoryAware {
    private AbstractBeanFactory beanFactory;
    private MultipartAwareFormHttpMessageConverter delegate = new MultipartAwareFormHttpMessageConverter();
    private Class<T> targetType;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (AbstractBeanFactory)beanFactory;
    }

    public void setTargetType(Class<T> targetType) {
        this.targetType = targetType;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Arrays.asList(MediaType.TEXT_PLAIN);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return clazz.isAssignableFrom(this.targetType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public T read(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        MultiValueMap map = this.delegate.read(null, inputMessage);
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(this.targetType);
        this.initBeanWrapper(beanWrapper);
        HashMap<String, Object> props = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            if (!beanWrapper.isWritableProperty(key)) continue;
            List list = (List)map.get((Object)key);
            props.put(key, ((List)map.get((Object)key)).size() > 1 ? list : map.getFirst((Object)key));
        }
        beanWrapper.setPropertyValues(props);
        Object result = beanWrapper.getWrappedInstance();
        return (T)result;
    }

    public void write(T input, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        throw new UnsupportedOperationException();
    }

    private void initBeanWrapper(BeanWrapperImpl beanWrapper) {
        GenericConversionService conversionService = new GenericConversionService();
        conversionService.addConverter((Converter)new MultipartFileConverter((PropertyEditorRegistry)beanWrapper));
        beanWrapper.setConversionService((ConversionService)conversionService);
        if (this.beanFactory != null) {
            this.beanFactory.copyRegisteredEditorsTo((PropertyEditorRegistry)beanWrapper);
        }
    }

    private static class MultipartFileConverter
    implements Converter<MultipartFile, String> {
        private final PropertyEditorRegistry accessor;

        public MultipartFileConverter(PropertyEditorRegistry accessor) {
            this.accessor = accessor;
        }

        public String convert(MultipartFile source) {
            PropertyEditor editor = this.accessor.findCustomEditor(MultipartFile.class, null);
            if (editor == null) {
                throw new IllegalStateException("Cannot convert source of type " + source.getClass() + " to type: String");
            }
            editor.setValue(source);
            return editor.getAsText();
        }
    }
}

