/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.poller.scheduling;

import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.batch.poller.Poller;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ConcurrentTaskScheduler;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.ErrorHandler;
import org.springframework.util.ReflectionUtils;

public class TaskSchedulerPoller<T>
implements Poller<T>,
BeanFactoryAware,
InitializingBean {
    private static final String TASK_SCHEDULER_BEAN_NAME = "taskScheduler";
    private volatile Trigger trigger;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();
    private TaskScheduler taskScheduler;
    private BeanFactory beanFactory;

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            if (this.trigger == null) {
                this.trigger = new PeriodicTrigger(100L);
            }
            if (this.taskScheduler == null && this.beanFactory != null) {
                this.taskScheduler = (TaskScheduler)this.beanFactory.getBean(TASK_SCHEDULER_BEAN_NAME, TaskScheduler.class);
            }
        }
    }

    private ScheduledFuture<?> getSchedule(final Callable<T> callable, final Queue<T> queue, final AtomicReference<Throwable> throwable) {
        TaskScheduler scheduler = this.taskScheduler;
        if (scheduler == null) {
            ConcurrentTaskScheduler concurrentTaskScheduler = new ConcurrentTaskScheduler();
            concurrentTaskScheduler.setErrorHandler((ErrorHandler)new PropagatingErrorHandler());
            scheduler = concurrentTaskScheduler;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                Object result;
                if (!queue.isEmpty() || throwable.get() != null) {
                    return;
                }
                try {
                    result = callable.call();
                }
                catch (RuntimeException e) {
                    throwable.set(e);
                    throw e;
                }
                catch (Exception e) {
                    throwable.set(e);
                    throw new IllegalStateException("Could not obtain result", e);
                }
                if (result != null) {
                    queue.add(result);
                }
            }
        };
        ScheduledFuture schedule = scheduler.schedule(task, this.trigger);
        return schedule;
    }

    public Future<T> poll(Callable<T> callback) throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        final LinkedBlockingQueue queue = new LinkedBlockingQueue(1);
        final AtomicReference<Throwable> throwable = new AtomicReference<Throwable>();
        final ScheduledFuture<?> schedule = this.getSchedule(callback, queue, throwable);
        return new Future<T>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return schedule.cancel(mayInterruptIfRunning);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() throws InterruptedException, ExecutionException {
                try {
                    Object result = queue.take();
                    if (throwable.get() != null) {
                        throw new ExecutionException((Throwable)throwable.get());
                    }
                    Object e = result;
                    return e;
                }
                finally {
                    this.cancelAndMaybeRethrow(schedule);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    Object result = queue.poll(timeout, unit);
                    if (throwable.get() != null) {
                        throw new ExecutionException((Throwable)throwable.get());
                    }
                    Object e = result;
                    return e;
                }
                finally {
                    this.cancelAndMaybeRethrow(schedule);
                }
            }

            @Override
            public boolean isCancelled() {
                return schedule.isCancelled();
            }

            @Override
            public boolean isDone() {
                return schedule.isDone() || !queue.isEmpty();
            }

            private void cancelAndMaybeRethrow(ScheduledFuture<?> schedule2) throws InterruptedException, ExecutionException {
                try {
                    schedule2.get();
                }
                catch (ExecutionException e) {
                    throw e;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw e;
                }
                schedule2.cancel(true);
            }
        };
    }

    static class PropagatingErrorHandler
    implements ErrorHandler {
        PropagatingErrorHandler() {
        }

        public void handleError(Throwable t) {
            ReflectionUtils.rethrowRuntimeException((Throwable)t);
        }
    }
}

