/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.Iterator;
import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.NoWorkFoundException;
import org.springframework.batch.item.database.KeyCollector;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DrivingQueryItemReader
implements ItemReader,
InitializingBean,
ItemStream {
    private boolean initialized = false;
    private List keys;
    private Iterator keysIterator;
    private int currentIndex = 0;
    private int lastCommitIndex = 0;
    private KeyCollector keyGenerator;
    private boolean saveState = false;

    public DrivingQueryItemReader() {
    }

    public DrivingQueryItemReader(List keys) {
        this.keys = keys;
        this.keysIterator = keys.iterator();
    }

    public Object read() {
        if (this.keysIterator.hasNext()) {
            ++this.currentIndex;
            return this.keysIterator.next();
        }
        return null;
    }

    protected Object getCurrentKey() {
        if (this.initialized && this.currentIndex > 0) {
            return this.keys.get(this.currentIndex - 1);
        }
        return null;
    }

    public void close(ExecutionContext executionContext) {
        this.initialized = false;
        this.currentIndex = 0;
        this.lastCommitIndex = 0;
        this.keys = null;
        this.keysIterator = null;
    }

    public void open(ExecutionContext executionContext) {
        Assert.state((this.keys == null && !this.initialized ? 1 : 0) != 0, (String)"Cannot open an already opened input source, call close() first.");
        this.keys = this.keyGenerator.retrieveKeys(executionContext);
        if (this.keys == null || this.keys.size() == 0) {
            throw new NoWorkFoundException("KeyGenerator must return at least 1 key");
        }
        this.keysIterator = this.keys.listIterator();
        this.initialized = true;
    }

    public void update(ExecutionContext executionContext) {
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            if (this.getCurrentKey() != null) {
                this.keyGenerator.updateContext(this.getCurrentKey(), executionContext);
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.keyGenerator, (String)"The KeyGenerator must not be null.");
    }

    public void setKeyCollector(KeyCollector keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void mark() {
        this.lastCommitIndex = this.currentIndex;
    }

    public void reset() {
        this.keysIterator = this.keys.listIterator(this.lastCommitIndex);
        this.currentIndex = this.lastCommitIndex;
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }
}

