/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import org.hibernate.SessionFactory;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.AbstractTransactionalResourceItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.hibernate3.HibernateOperations;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.util.Assert;

public class HibernateAwareItemWriter
extends AbstractTransactionalResourceItemWriter
implements InitializingBean {
    private static final String ITEMS_PROCESSED = HibernateAwareItemWriter.class.getName() + ".ITEMS_PROCESSED";
    private ItemWriter delegate;
    private HibernateOperations hibernateTemplate;

    public void setDelegate(ItemWriter delegate) {
        this.delegate = delegate;
    }

    public void setHibernateTemplate(HibernateOperations hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.delegate, (String)"HibernateAwareItemWriter requires an ItemWriter as a delegate.");
        Assert.notNull((Object)this.hibernateTemplate, (String)"HibernateAwareItemWriter requires a HibernateOperations");
    }

    protected void doFlush() {
        this.delegate.flush();
        this.hibernateTemplate.flush();
        this.hibernateTemplate.clear();
    }

    protected void doClear() throws ClearFailedException {
        this.delegate.clear();
        this.hibernateTemplate.clear();
    }

    protected String getResourceKey() {
        return ITEMS_PROCESSED;
    }

    protected void doWrite(Object output) throws Exception {
        this.delegate.write(output);
    }
}

