/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ExecutionContextUserSupport;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class HibernateCursorItemReader
extends ExecutionContextUserSupport
implements ItemReader,
ItemStream,
InitializingBean {
    private static final String RESTART_DATA_ROW_NUMBER_KEY = "row.number";
    private SessionFactory sessionFactory;
    private StatelessSession statelessSession;
    private Session statefulSession;
    private ScrollableResults cursor;
    private String queryString;
    private boolean useStatelessSession = true;
    private int lastCommitRowNumber = 0;
    private int currentProcessedRow = 0;
    private boolean initialized = false;
    private boolean saveState = false;

    public HibernateCursorItemReader() {
        this.setName(ClassUtils.getShortName((Class)HibernateCursorItemReader.class));
    }

    public Object read() {
        if (this.cursor.next()) {
            ++this.currentProcessedRow;
            Object[] data = this.cursor.get();
            if (data.length > 1) {
                return data;
            }
            return data[0];
        }
        return null;
    }

    public void close(ExecutionContext executionContext) {
        this.initialized = false;
        if (this.cursor != null) {
            this.cursor.close();
        }
        this.currentProcessedRow = 0;
        if (this.useStatelessSession) {
            if (this.statelessSession != null) {
                this.statelessSession.close();
            }
        } else if (this.statefulSession != null) {
            this.statefulSession.close();
        }
    }

    public void open(ExecutionContext executionContext) {
        Assert.state((!this.initialized ? 1 : 0) != 0, (String)"Cannot open an already opened ItemReader, call close first");
        if (this.useStatelessSession) {
            this.statelessSession = this.sessionFactory.openStatelessSession();
            this.cursor = this.statelessSession.createQuery(this.queryString).scroll();
        } else {
            this.statefulSession = this.sessionFactory.openSession();
            this.cursor = this.statefulSession.createQuery(this.queryString).scroll();
        }
        this.initialized = true;
        if (executionContext.containsKey(this.getKey(RESTART_DATA_ROW_NUMBER_KEY))) {
            this.currentProcessedRow = Integer.parseInt(executionContext.getString(this.getKey(RESTART_DATA_ROW_NUMBER_KEY)));
            this.cursor.setRowNumber(this.currentProcessedRow - 1);
        }
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.sessionFactory);
        Assert.hasLength((String)this.queryString);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setUseStatelessSession(boolean useStatelessSession) {
        Assert.state((!this.initialized ? 1 : 0) != 0);
        this.useStatelessSession = useStatelessSession;
    }

    public void update(ExecutionContext executionContext) {
        if (this.saveState) {
            Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
            executionContext.putString(this.getKey(RESTART_DATA_ROW_NUMBER_KEY), "" + this.currentProcessedRow);
        }
    }

    public void mark() {
        this.lastCommitRowNumber = this.currentProcessedRow;
        if (!this.useStatelessSession) {
            this.statefulSession.clear();
        }
    }

    public void reset() {
        this.currentProcessedRow = this.lastCommitRowNumber;
        if (this.lastCommitRowNumber == 0) {
            this.cursor.beforeFirst();
        } else {
            this.cursor.setRowNumber(this.lastCommitRowNumber - 1);
        }
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }
}

