/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.springframework.batch.item.ClearFailedException;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ExecutionContextUserSupport;
import org.springframework.batch.item.FlushFailedException;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.MarkFailedException;
import org.springframework.batch.item.ResetFailedException;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.mapping.FieldSetCreator;
import org.springframework.batch.item.file.transform.DelimitedLineAggregator;
import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class FlatFileItemWriter
extends ExecutionContextUserSupport
implements ItemWriter,
ItemStream,
InitializingBean {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String WRITTEN_STATISTICS_NAME = "written";
    private static final String RESTART_COUNT_STATISTICS_NAME = "restart.count";
    private static final String RESTART_DATA_NAME = "current.count";
    private Resource resource;
    private OutputState state = null;
    private LineAggregator lineAggregator = new DelimitedLineAggregator();
    private FieldSetCreator fieldSetCreator;
    private boolean saveState = false;
    private boolean shouldDeleteIfExists = true;
    private String encoding = "UTF-8";
    private int bufferSize = 2048;
    private List lineBuffer = new ArrayList();

    public FlatFileItemWriter() {
        this.setName(ClassUtils.getShortName((Class)FlatFileItemWriter.class));
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource, (String)"The resource must be set");
        Assert.notNull((Object)this.fieldSetCreator, (String)"A FieldSetCreator must be provided.");
    }

    public void setLineAggregator(LineAggregator lineAggregator) {
        this.lineAggregator = lineAggregator;
    }

    public void setFieldSetCreator(FieldSetCreator fieldSetCreator) {
        this.fieldSetCreator = fieldSetCreator;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void write(Object data) throws Exception {
        FieldSet fieldSet = this.fieldSetCreator.mapItem(data);
        this.lineBuffer.add(this.lineAggregator.aggregate(fieldSet) + LINE_SEPARATOR);
    }

    public void close(ExecutionContext executionContext) {
        if (this.state != null) {
            this.getOutputState().close();
            this.state = null;
        }
    }

    public void setEncoding(String newEncoding) {
        this.encoding = newEncoding;
    }

    public void setBufferSize(int newSize) {
        this.bufferSize = newSize;
    }

    public void setShouldDeleteIfExists(boolean shouldDeleteIfExists) {
        this.shouldDeleteIfExists = shouldDeleteIfExists;
    }

    public void open(ExecutionContext executionContext) {
        OutputState outputState = this.getOutputState();
        if (executionContext.containsKey(this.getKey(RESTART_DATA_NAME))) {
            outputState.restoreFrom(executionContext);
        }
        outputState.initializeBufferedWriter();
    }

    public void update(ExecutionContext executionContext) {
        if (this.state == null) {
            throw new ItemStreamException("ItemStream not open or already closed.");
        }
        Assert.notNull((Object)executionContext, (String)"ExecutionContext must not be null");
        if (this.saveState) {
            try {
                executionContext.putLong(this.getKey(RESTART_DATA_NAME), this.state.position());
            }
            catch (IOException e) {
                throw new ItemStreamException("ItemStream does not return current position properly", e);
            }
            executionContext.putLong(this.getKey(WRITTEN_STATISTICS_NAME), this.state.linesWritten);
            executionContext.putLong(this.getKey(RESTART_COUNT_STATISTICS_NAME), this.state.restartCount);
        }
    }

    private OutputState getOutputState() {
        if (this.state == null) {
            try {
                File file = this.resource.getFile();
                Assert.state((!file.exists() || file.canWrite() ? 1 : 0) != 0, (String)("Resource is not writable: [" + this.resource + "]"));
            }
            catch (IOException e) {
                throw new ItemStreamException("Could not test resource for writable status.", e);
            }
            this.state = new OutputState();
            this.state.setDeleteIfExists(this.shouldDeleteIfExists);
            this.state.setBufferSize(this.bufferSize);
            this.state.setEncoding(this.encoding);
        }
        return this.state;
    }

    public void clear() throws ClearFailedException {
        this.lineBuffer.clear();
    }

    public void flush() throws FlushFailedException {
        OutputState state = this.getOutputState();
        ListIterator iterator = this.lineBuffer.listIterator();
        while (iterator.hasNext()) {
            String line = (String)iterator.next();
            try {
                state.write(line);
            }
            catch (IOException e) {
                throw new FlushFailedException("Failed to write line to output file: " + line, e);
            }
        }
        this.lineBuffer.clear();
        state.mark();
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    private class OutputState {
        private static final String DEFAULT_CHARSET = "UTF-8";
        private static final int DEFAULT_BUFFER_SIZE = 2048;
        BufferedWriter outputBufferedWriter;
        FileChannel fileChannel;
        String encoding = "UTF-8";
        int bufferSize = 2048;
        boolean restarted = false;
        boolean initialized = false;
        long lastMarkedByteOffsetPosition = 0L;
        long linesWritten = 0L;
        long restartCount = 0L;
        boolean shouldDeleteIfExists = true;

        private OutputState() {
        }

        public long position() throws IOException {
            long pos = 0L;
            if (this.fileChannel == null) {
                return 0L;
            }
            this.outputBufferedWriter.flush();
            pos = this.fileChannel.position();
            return pos;
        }

        public void restoreFrom(ExecutionContext executionContext) {
            this.lastMarkedByteOffsetPosition = executionContext.getLong(FlatFileItemWriter.this.getKey(FlatFileItemWriter.RESTART_DATA_NAME));
            this.restarted = true;
        }

        public void setDeleteIfExists(boolean shouldDeleteIfExists) {
            this.shouldDeleteIfExists = shouldDeleteIfExists;
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public void close() {
            this.initialized = false;
            this.restarted = false;
            try {
                if (this.outputBufferedWriter == null) {
                    return;
                }
                this.outputBufferedWriter.close();
                this.fileChannel.close();
            }
            catch (IOException ioe) {
                throw new ItemStreamException("Unable to close the the ItemWriter", ioe);
            }
        }

        public void write(String line) throws IOException {
            if (!this.initialized) {
                this.initializeBufferedWriter();
            }
            this.outputBufferedWriter.write(line);
            this.outputBufferedWriter.flush();
            ++this.linesWritten;
        }

        public void truncate() throws IOException {
            this.fileChannel.truncate(this.lastMarkedByteOffsetPosition);
            this.fileChannel.position(this.lastMarkedByteOffsetPosition);
        }

        public void mark() {
            try {
                this.lastMarkedByteOffsetPosition = this.position();
            }
            catch (IOException e) {
                throw new MarkFailedException("Unable to get position for mark", e);
            }
        }

        private void initializeBufferedWriter() {
            File file;
            try {
                file = FlatFileItemWriter.this.resource.getFile();
                if (!this.restarted) {
                    String parent;
                    if (file.exists()) {
                        if (this.shouldDeleteIfExists) {
                            file.delete();
                        } else {
                            throw new ItemStreamException("Resource already exists: " + FlatFileItemWriter.this.resource);
                        }
                    }
                    if ((parent = file.getParent()) != null) {
                        new File(parent).mkdirs();
                    }
                    file.createNewFile();
                }
            }
            catch (IOException ioe) {
                throw new DataAccessResourceFailureException("Unable to write to file resource: [" + FlatFileItemWriter.this.resource + "]", (Throwable)ioe);
            }
            try {
                this.fileChannel = new FileOutputStream(file.getAbsolutePath(), true).getChannel();
            }
            catch (FileNotFoundException fnfe) {
                throw new ItemStreamException("Bad filename property parameter " + file, fnfe);
            }
            this.outputBufferedWriter = this.getBufferedWriter(this.fileChannel, this.encoding, this.bufferSize);
            if (this.restarted) {
                this.reset();
            }
            this.initialized = true;
            this.linesWritten = 0L;
        }

        private BufferedWriter getBufferedWriter(FileChannel fileChannel, String encoding, int bufferSize) {
            try {
                BufferedWriter outputBufferedWriter = null;
                outputBufferedWriter = bufferSize > 0 ? new BufferedWriter(Channels.newWriter((WritableByteChannel)fileChannel, encoding), bufferSize) : new BufferedWriter(Channels.newWriter((WritableByteChannel)fileChannel, encoding));
                return outputBufferedWriter;
            }
            catch (UnsupportedCharsetException ucse) {
                throw new ItemStreamException("Bad encoding configuration for output file " + fileChannel, ucse);
            }
        }

        public void reset() throws ResetFailedException {
            this.checkFileSize();
            try {
                FlatFileItemWriter.this.getOutputState().truncate();
            }
            catch (IOException e) {
                throw new ResetFailedException("Unable to truncate file", e);
            }
        }

        private void checkFileSize() {
            long size = -1L;
            try {
                this.outputBufferedWriter.flush();
                size = this.fileChannel.size();
            }
            catch (IOException e) {
                throw new ResetFailedException("An Error occured while checking file size", e);
            }
            if (size < this.lastMarkedByteOffsetPosition) {
                throw new ResetFailedException("Current file size is smaller than size at last commit");
            }
        }
    }
}

