/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.context.SynchronizedAttributeAccessor;

public class RepeatContextSupport
extends SynchronizedAttributeAccessor
implements RepeatContext {
    private RepeatContext parent;
    private int count;
    private volatile boolean completeOnly;
    private volatile boolean terminateOnly;
    private Map callbacks = new HashMap();

    public RepeatContextSupport(RepeatContext parent) {
        this.parent = parent;
    }

    public boolean isCompleteOnly() {
        return this.completeOnly;
    }

    public void setCompleteOnly() {
        this.completeOnly = true;
    }

    public boolean isTerminateOnly() {
        return this.terminateOnly;
    }

    public void setTerminateOnly() {
        this.terminateOnly = true;
        this.setCompleteOnly();
    }

    public RepeatContext getParent() {
        return this.parent;
    }

    public synchronized void increment() {
        ++this.count;
    }

    public synchronized int getStartedCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDestructionCallback(String name, Runnable callback) {
        Map map = this.callbacks;
        synchronized (map) {
            HashSet<Runnable> set = (HashSet<Runnable>)this.callbacks.get(name);
            if (set == null) {
                set = new HashSet<Runnable>();
                this.callbacks.put(name, set);
            }
            set.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashSet copy;
        ArrayList<RuntimeException> errors = new ArrayList<RuntimeException>();
        Map map = this.callbacks;
        synchronized (map) {
            copy = new HashSet(this.callbacks.entrySet());
        }
        Iterator iter = copy.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Set set = (Set)entry.getValue();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Runnable callback = (Runnable)iterator.next();
                if (callback == null) continue;
                try {
                    callback.run();
                }
                catch (RuntimeException t) {
                    errors.add(t);
                }
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        throw (RuntimeException)errors.get(0);
    }
}

