/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.exception;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.exception.ExceptionHandler;
import org.springframework.batch.support.ExceptionClassifier;
import org.springframework.batch.support.ExceptionClassifierSupport;

public class LogOrRethrowExceptionHandler
implements ExceptionHandler {
    public static final String RETHROW = "rethrow";
    public static final String DEBUG = "debug";
    public static final String WARN = "warn";
    public static final String ERROR = "error";
    protected final Log logger = LogFactory.getLog((Class)LogOrRethrowExceptionHandler.class);
    private ExceptionClassifier exceptionClassifier = new ExceptionClassifierSupport(){

        public Object classify(Throwable throwable) {
            return LogOrRethrowExceptionHandler.RETHROW;
        }
    };

    public void setExceptionClassifier(ExceptionClassifier exceptionClassifier) {
        this.exceptionClassifier = exceptionClassifier;
    }

    public void handleException(RepeatContext context, Throwable throwable) throws Throwable {
        Object key = this.exceptionClassifier.classify(throwable);
        if (ERROR.equals(key)) {
            this.logger.error((Object)"Exception encountered in batch repeat.", throwable);
        } else if (WARN.equals(key)) {
            this.logger.warn((Object)"Exception encountered in batch repeat.", throwable);
        } else if (DEBUG.equals(key) && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Exception encountered in batch repeat.", throwable);
        } else {
            if (RETHROW.equals(key)) {
                throw throwable;
            }
            throw new IllegalStateException("Unclassified exception encountered.  Did you mean to classifiy this as 'rethrow'?");
        }
    }
}

