/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.interceptor;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.batch.repeat.ExitStatus;
import org.springframework.batch.repeat.RepeatCallback;
import org.springframework.batch.repeat.RepeatContext;
import org.springframework.batch.repeat.RepeatException;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.util.Assert;

public class RepeatOperationsInterceptor
implements MethodInterceptor {
    private RepeatOperations repeatOperations = new RepeatTemplate();

    public void setRepeatOperations(RepeatOperations batchTempate) {
        Assert.notNull((Object)batchTempate, (String)"'repeatOperations' cannot be null.");
        this.repeatOperations = batchTempate;
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        this.repeatOperations.iterate(new RepeatCallback(){

            public ExitStatus doInIteration(RepeatContext context) throws Exception {
                try {
                    MethodInvocation clone = invocation;
                    if (!(invocation instanceof ProxyMethodInvocation)) {
                        throw new IllegalStateException("MethodInvocation of the wrong type detected - this should not happen with Spring AOP, so please raise an issue if you see this exception");
                    }
                    clone = ((ProxyMethodInvocation)invocation).invocableClone();
                    if (clone.getMethod().getReturnType().equals(Void.TYPE)) {
                        clone.proceed();
                        return ExitStatus.CONTINUABLE;
                    }
                    return new ExitStatus(clone.proceed() != null);
                }
                catch (Throwable e) {
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new RepeatException("Unexpected error in batch interceptor", e);
                }
            }
        });
        return null;
    }
}

