/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.repeat.support;

import edu.emory.mathcs.backport.java.util.concurrent.ArrayBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.Semaphore;
import org.springframework.batch.repeat.support.AbstractResultQueue;
import org.springframework.batch.repeat.support.RepeatInternalState;
import org.springframework.batch.repeat.support.ResultHolder;

class BackportConcurrentResultQueue
extends AbstractResultQueue
implements RepeatInternalState {
    private final BlockingQueue results;
    private final Semaphore waits;

    BackportConcurrentResultQueue(int throttleLimit) {
        this.results = new ArrayBlockingQueue(throttleLimit);
        this.waits = new Semaphore(throttleLimit);
    }

    protected void addResult(ResultHolder resultHolder) {
        this.results.add((Object)resultHolder);
    }

    protected void aquireWait() throws InterruptedException {
        this.waits.acquire();
    }

    protected void releaseWait() {
        this.waits.release();
    }

    protected ResultHolder takeResult() throws InterruptedException {
        return (ResultHolder)this.results.take();
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }
}

