/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.callback;

import org.springframework.batch.item.FailedItemIdentifier;
import org.springframework.batch.item.ItemKeyGenerator;
import org.springframework.batch.item.ItemRecoverer;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;

public class ItemWriterRetryCallback
implements RetryCallback {
    private Object item;
    private ItemWriter writer;
    private ItemRecoverer recoverer;
    private ItemKeyGenerator keyGenerator;
    private FailedItemIdentifier failedItemIdentifier;
    private ItemKeyGenerator defaultKeyGenerator = new ItemKeyGenerator(){

        public Object getKey(Object item) {
            return item;
        }
    };

    public ItemWriterRetryCallback(Object item, ItemWriter writer) {
        this.item = item;
        this.writer = writer;
    }

    public void setRecoverer(ItemRecoverer recoverer) {
        this.recoverer = recoverer;
    }

    public void setKeyGenerator(ItemKeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setFailedItemIdentifier(FailedItemIdentifier failedItemIdentifier) {
        this.failedItemIdentifier = failedItemIdentifier;
    }

    public Object doWithRetry(RetryContext context) throws Throwable {
        if (!context.isExhaustedOnly()) {
            if (this.item != null) {
                this.writer.write(this.item);
            }
            return null;
        }
        throw new RetryException("Recovery path requested in retry callback.");
    }

    public Object getItem() {
        return this.item;
    }

    public ItemKeyGenerator getKeyGenerator() {
        if (this.keyGenerator != null) {
            return this.keyGenerator;
        }
        if (this.writer instanceof ItemKeyGenerator) {
            return (ItemKeyGenerator)((Object)this.writer);
        }
        return this.defaultKeyGenerator;
    }

    public FailedItemIdentifier getFailedItemIdentifier() {
        if (this.failedItemIdentifier != null) {
            return this.failedItemIdentifier;
        }
        if (this.writer instanceof FailedItemIdentifier) {
            return (FailedItemIdentifier)((Object)this.writer);
        }
        return null;
    }

    public ItemRecoverer getRecoverer() {
        if (this.recoverer != null) {
            return this.recoverer;
        }
        if (this.writer instanceof ItemRecoverer) {
            return (ItemRecoverer)((Object)this.writer);
        }
        return null;
    }
}

