/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.policy.MapRetryContextCache;
import org.springframework.batch.retry.policy.RetryContextCache;

public abstract class AbstractStatefulRetryPolicy
implements RetryPolicy {
    private volatile Set recoverableExceptionClasses = new HashSet();
    protected RetryContextCache retryContextCache = new MapRetryContextCache();

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.retryContextCache = retryContextCache;
    }

    public Object handleRetryExhausted(RetryContext context) throws Exception {
        return null;
    }

    public boolean shouldRethrow(RetryContext context) {
        return !this.recoverForException(context.getLastThrowable());
    }

    public final void setRecoverableExceptionClasses(Class[] retryableExceptionClasses) {
        HashSet temp = new HashSet();
        for (int i = 0; i < retryableExceptionClasses.length; ++i) {
            this.addRecoverableExceptionClass(retryableExceptionClasses[i], temp);
        }
        this.recoverableExceptionClasses = temp;
    }

    private void addRecoverableExceptionClass(Class retryableExceptionClass, Set set) {
        if (!Throwable.class.isAssignableFrom(retryableExceptionClass)) {
            throw new IllegalArgumentException("Class '" + retryableExceptionClass.getName() + "' is not a subtype of Throwable.");
        }
        set.add(retryableExceptionClass);
    }

    protected boolean recoverForException(Throwable ex) {
        if (ex == null) {
            return false;
        }
        Class<?> exceptionClass = ex.getClass();
        if (this.recoverableExceptionClasses.contains(exceptionClass)) {
            return true;
        }
        Iterator iterator = this.recoverableExceptionClasses.iterator();
        while (iterator.hasNext()) {
            Class cls = (Class)iterator.next();
            if (!cls.isAssignableFrom(exceptionClass)) continue;
            this.addRecoverableExceptionClass(exceptionClass, this.recoverableExceptionClasses);
            return true;
        }
        return false;
    }
}

