/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.TerminatedRetryException;
import org.springframework.batch.retry.context.RetryContextSupport;
import org.springframework.batch.retry.policy.AbstractStatelessRetryPolicy;

public class CompositeRetryPolicy
extends AbstractStatelessRetryPolicy {
    RetryPolicy[] policies = new RetryPolicy[0];

    public void setPolicies(RetryPolicy[] policies) {
        this.policies = policies;
    }

    public boolean canRetry(RetryContext context) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        for (int i = 0; i < contexts.length; ++i) {
            if (policies[i].canRetry(contexts[i])) continue;
            return false;
        }
        return true;
    }

    public void close(RetryContext context) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        for (int i = 0; i < contexts.length; ++i) {
            policies[i].close(contexts[i]);
        }
    }

    public RetryContext open(RetryCallback callback, RetryContext parent) {
        ArrayList<RetryContext> list = new ArrayList<RetryContext>();
        for (int i = 0; i < this.policies.length; ++i) {
            list.add(this.policies[i].open(callback, parent));
        }
        return new CompositeRetryContext(parent, list);
    }

    public void registerThrowable(RetryContext context, Throwable throwable) throws TerminatedRetryException {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        for (int i = 0; i < contexts.length; ++i) {
            policies[i].registerThrowable(contexts[i], throwable);
        }
        ((RetryContextSupport)context).registerThrowable(throwable);
    }

    private class CompositeRetryContext
    extends RetryContextSupport {
        RetryContext[] contexts;
        RetryPolicy[] policies;

        public CompositeRetryContext(RetryContext parent, List contexts) {
            super(parent);
            this.contexts = contexts.toArray(new RetryContext[0]);
            this.policies = CompositeRetryPolicy.this.policies;
        }
    }
}

