/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.TerminatedRetryException;
import org.springframework.batch.retry.context.RetryContextSupport;
import org.springframework.batch.retry.policy.AbstractStatelessRetryPolicy;
import org.springframework.batch.retry.policy.NeverRetryPolicy;
import org.springframework.batch.support.ExceptionClassifier;
import org.springframework.batch.support.ExceptionClassifierSupport;
import org.springframework.util.Assert;

public class ExceptionClassifierRetryPolicy
extends AbstractStatelessRetryPolicy {
    private ExceptionClassifier exceptionClassifier = new ExceptionClassifierSupport();
    private Map policyMap = new HashMap();

    public ExceptionClassifierRetryPolicy() {
        this.policyMap.put("default", new NeverRetryPolicy());
    }

    public void setPolicyMap(Map policyMap) {
        this.policyMap = policyMap;
    }

    public void setExceptionClassifier(ExceptionClassifier exceptionClassifier) {
        this.exceptionClassifier = exceptionClassifier;
    }

    public boolean canRetry(RetryContext context) {
        RetryPolicy policy = (RetryPolicy)((Object)context);
        return policy.canRetry(context);
    }

    public void close(RetryContext context) {
        RetryPolicy policy = (RetryPolicy)((Object)context);
        policy.close(context);
    }

    public RetryContext open(RetryCallback callback, RetryContext parent) {
        return new ExceptionClassifierRetryContext(parent, this.exceptionClassifier).open(callback, parent);
    }

    public void registerThrowable(RetryContext context, Throwable throwable) throws TerminatedRetryException {
        RetryPolicy policy = (RetryPolicy)((Object)context);
        policy.registerThrowable(context, throwable);
        ((RetryContextSupport)context).registerThrowable(throwable);
    }

    private class ExceptionClassifierRetryContext
    extends RetryContextSupport
    implements RetryPolicy {
        private ExceptionClassifier exceptionClassifier;
        RetryPolicy policy;
        RetryContext context;
        RetryCallback callback;
        Map contexts;

        public ExceptionClassifierRetryContext(RetryContext parent, ExceptionClassifier exceptionClassifier) {
            super(parent);
            this.contexts = new HashMap();
            this.exceptionClassifier = exceptionClassifier;
            Object key = exceptionClassifier.getDefault();
            this.policy = this.getPolicy(key);
            Assert.notNull((Object)this.policy, (String)("Could not locate default policy: key=[" + key + "]."));
        }

        public boolean canRetry(RetryContext context) {
            return this.policy.canRetry(this.context);
        }

        public boolean shouldRethrow(RetryContext context) {
            return this.policy.shouldRethrow(context);
        }

        public void close(RetryContext context) {
            Iterator iter = this.contexts.keySet().iterator();
            while (iter.hasNext()) {
                RetryPolicy policy = (RetryPolicy)iter.next();
                policy.close(this.getContext(policy));
            }
        }

        public RetryContext open(RetryCallback callback, RetryContext parent) {
            this.callback = callback;
            return this;
        }

        public void registerThrowable(RetryContext context, Throwable throwable) throws TerminatedRetryException {
            this.policy = this.getPolicy(this.exceptionClassifier.classify(throwable));
            this.context = this.getContext(this.policy);
            this.policy.registerThrowable(this.context, throwable);
        }

        private RetryContext getContext(RetryPolicy policy) {
            RetryContext context = (RetryContext)this.contexts.get(policy);
            if (context == null) {
                context = policy.open(this.callback, null);
                this.contexts.put(policy, context);
            }
            return context;
        }

        private RetryPolicy getPolicy(Object key) {
            RetryPolicy result = (RetryPolicy)ExceptionClassifierRetryPolicy.this.policyMap.get(key);
            Assert.notNull((Object)result, (String)("Could not locate policy for key=[" + key + "]."));
            return result;
        }

        public Object handleRetryExhausted(RetryContext context) throws Exception {
            throw new UnsupportedOperationException("Not supported - this code should be unreachable.");
        }
    }
}

