/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.FailedItemIdentifier;
import org.springframework.batch.item.ItemKeyGenerator;
import org.springframework.batch.item.ItemRecoverer;
import org.springframework.batch.repeat.support.RepeatSynchronizationManager;
import org.springframework.batch.retry.RetryCallback;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryException;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.TerminatedRetryException;
import org.springframework.batch.retry.callback.ItemWriterRetryCallback;
import org.springframework.batch.retry.context.RetryContextSupport;
import org.springframework.batch.retry.policy.AbstractStatefulRetryPolicy;
import org.springframework.batch.retry.policy.SimpleRetryPolicy;
import org.springframework.util.Assert;

public class ItemWriterRetryPolicy
extends AbstractStatefulRetryPolicy {
    protected Log logger = LogFactory.getLog(this.getClass());
    public static final String EXHAUSTED = ItemWriterRetryPolicy.class.getName() + ".EXHAUSTED";
    private RetryPolicy delegate;

    public ItemWriterRetryPolicy(RetryPolicy delegate) {
        this.delegate = delegate;
    }

    public ItemWriterRetryPolicy() {
        this(new SimpleRetryPolicy());
    }

    public void setDelegate(RetryPolicy delegate) {
        this.delegate = delegate;
    }

    public boolean canRetry(RetryContext context) {
        return ((RetryPolicy)((Object)context)).canRetry(context);
    }

    public void close(RetryContext context) {
        ((RetryPolicy)((Object)context)).close(context);
    }

    public RetryContext open(RetryCallback callback, RetryContext parent) {
        Assert.state((boolean)(callback instanceof ItemWriterRetryCallback), (String)"Callback must be ItemProviderRetryCallback");
        ItemWriterRetryContext context = new ItemWriterRetryContext((ItemWriterRetryCallback)callback, parent);
        context.open(callback, null);
        return context;
    }

    public void registerThrowable(RetryContext context, Throwable throwable) throws TerminatedRetryException {
        ((RetryPolicy)((Object)context)).registerThrowable(context, throwable);
    }

    public Object handleRetryExhausted(RetryContext context) throws Exception {
        return ((RetryPolicy)((Object)context)).handleRetryExhausted(context);
    }

    protected boolean hasFailed(FailedItemIdentifier failedItemIdentifier, Object key) {
        if (failedItemIdentifier != null) {
            return failedItemIdentifier.hasFailed(key);
        }
        return this.retryContextCache.containsKey(key);
    }

    private class ItemWriterRetryContext
    extends RetryContextSupport
    implements RetryPolicy {
        private final Object item;
        private final Object key;
        private final int initialHashCode;
        private RetryContext delegateContext;
        private final ItemRecoverer recoverer;
        private final ItemKeyGenerator keyGenerator;
        private final FailedItemIdentifier failedItemIdentifier;

        public ItemWriterRetryContext(ItemWriterRetryCallback callback, RetryContext parent) {
            super(parent);
            this.recoverer = callback.getRecoverer();
            this.keyGenerator = callback.getKeyGenerator();
            this.item = callback.getItem();
            this.key = this.keyGenerator.getKey(this.item);
            this.failedItemIdentifier = callback.getFailedItemIdentifier();
            this.initialHashCode = this.key.hashCode();
        }

        public boolean canRetry(RetryContext context) {
            return ItemWriterRetryPolicy.this.delegate.canRetry(this.delegateContext);
        }

        public void close(RetryContext context) {
            ItemWriterRetryPolicy.this.delegate.close(this.delegateContext);
        }

        public RetryContext open(RetryCallback callback, RetryContext parent) {
            if (ItemWriterRetryPolicy.this.hasFailed(this.failedItemIdentifier, this.key)) {
                this.delegateContext = ItemWriterRetryPolicy.this.retryContextCache.get(this.key);
                if (this.delegateContext == null) {
                    throw new RetryException("Inconsistent state for failed item: no history found. Consider whether equals() or hashCode() for the item might be inconsistent, or if you need to supply a better ItemKeyGenerator");
                }
            } else {
                this.delegateContext = ItemWriterRetryPolicy.this.delegate.open(callback, null);
            }
            return null;
        }

        public void registerThrowable(RetryContext context, Throwable throwable) throws TerminatedRetryException {
            if (this.initialHashCode != this.key.hashCode()) {
                throw new RetryException("Inconsistent state for failed item key: hashCode has changed. Consider whether equals() or hashCode() for the item might be inconsistent, or if you need to supply a better ItemKeyGenerator");
            }
            ItemWriterRetryPolicy.this.retryContextCache.put(this.key, this.delegateContext);
            ItemWriterRetryPolicy.this.delegate.registerThrowable(this.delegateContext, throwable);
        }

        public boolean isExternal() {
            throw new UnsupportedOperationException("Not supported - this code should be unreachable.");
        }

        public boolean shouldRethrow(RetryContext context) {
            throw new UnsupportedOperationException("Not supported - this code should be unreachable.");
        }

        public Object handleRetryExhausted(RetryContext context) throws Exception {
            boolean success;
            ItemWriterRetryPolicy.this.retryContextCache.remove(this.key);
            RepeatSynchronizationManager.setCompleteOnly();
            if (this.recoverer != null && !(success = this.recoverer.recover(this.item, context.getLastThrowable()))) {
                int count = context.getRetryCount();
                ItemWriterRetryPolicy.this.logger.error((Object)("Could not recover from error after retry exhausted after [" + count + "] attempts."), context.getLastThrowable());
            }
            return this.item;
        }

        public Throwable getLastThrowable() {
            return this.delegateContext.getLastThrowable();
        }

        public int getRetryCount() {
            return this.delegateContext.getRetryCount();
        }
    }
}

