/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.util.Assert;

public class ExecutionContext
implements Serializable {
    private boolean dirty = false;
    private final Map map;

    public ExecutionContext() {
        this.map = new HashMap();
    }

    public ExecutionContext(Map map) {
        this.map = map;
    }

    public ExecutionContext(ExecutionContext executionContext) {
        this();
        if (executionContext == null) {
            return;
        }
        Iterator iterator = executionContext.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.map.put(entry.getKey(), entry.getValue());
        }
    }

    public void putString(String key, String value) {
        this.put(key, value);
    }

    public void putLong(String key, long value) {
        this.put(key, new Long(value));
    }

    public void putDouble(String key, double value) {
        this.put(key, new Double(value));
    }

    public void put(String key, Object value) {
        if (value != null) {
            Assert.isInstanceOf((Class)Serializable.class, (Object)value, (String)("Value: [ " + value + "must be serializable."));
        }
        this.dirty = true;
        this.map.put(key, value);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String getString(String key) {
        return (String)this.readAndValidate(key, String.class);
    }

    public String getString(String key, String defaultString) {
        if (!this.map.containsKey(key)) {
            return defaultString;
        }
        return (String)this.readAndValidate(key, String.class);
    }

    public long getLong(String key) {
        return (Long)this.readAndValidate(key, Long.class);
    }

    public long getLong(String key, long defaultLong) {
        if (!this.map.containsKey(key)) {
            return defaultLong;
        }
        return (Long)this.readAndValidate(key, Long.class);
    }

    public double getDouble(String key) {
        return (Double)this.readAndValidate(key, Double.class);
    }

    public double getDouble(String key, double defaultDouble) {
        if (!this.map.containsKey(key)) {
            return defaultDouble;
        }
        return (Double)this.readAndValidate(key, Double.class);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    private Object readAndValidate(String key, Class type) {
        Object value = this.map.get(key);
        if (!type.isInstance(value)) {
            throw new ClassCastException("Value for key=[" + key + "] is not of type: [" + type + "], it is [" + (value == null ? null : "(" + value.getClass() + ")" + value) + "]");
        }
        return value;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clearDirtyFlag() {
        this.dirty = false;
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        Iterator it = this.map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            props.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
        return props;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ExecutionContext)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExecutionContext rhs = (ExecutionContext)obj;
        return ((Object)this.entrySet()).equals(rhs.entrySet());
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public int size() {
        return this.map.size();
    }
}

