/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.file.transform;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.file.mapping.DefaultFieldSet;
import org.springframework.batch.item.file.mapping.FieldSet;
import org.springframework.batch.item.file.transform.IncorrectTokenCountException;
import org.springframework.batch.item.file.transform.LineTokenizer;

public abstract class AbstractLineTokenizer
implements LineTokenizer {
    protected String[] names = new String[0];

    public void setNames(String[] names) {
        this.names = names;
    }

    public boolean hasNames() {
        return this.names != null && this.names.length > 0;
    }

    public FieldSet tokenize(String line) {
        if (line == null) {
            line = "";
        }
        ArrayList tokens = new ArrayList(this.doTokenize(line));
        String[] values = tokens.toArray(new String[tokens.size()]);
        if (this.names.length == 0) {
            return new DefaultFieldSet(values);
        }
        if (values.length != this.names.length) {
            throw new IncorrectTokenCountException(this.names.length, values.length);
        }
        return new DefaultFieldSet(values, this.names);
    }

    protected abstract List doTokenize(String var1);
}

