/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.backoff;

import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.backoff.BackOffContext;
import org.springframework.batch.retry.backoff.BackOffInterruptedException;
import org.springframework.batch.retry.backoff.BackOffPolicy;
import org.springframework.batch.retry.backoff.ObjectWaitSleeper;
import org.springframework.batch.retry.backoff.Sleeper;
import org.springframework.util.ClassUtils;

public class ExponentialBackOffPolicy
implements BackOffPolicy {
    public static final long DEFAULT_INITIAL_INTERVAL = 100L;
    public static final long DEFAULT_MAX_INTERVAL = 30000L;
    public static final double DEFAULT_MULTIPLIER = 2.0;
    private volatile long initialInterval = 100L;
    private volatile long maxInterval = 30000L;
    private volatile double multiplier = 2.0;
    private Sleeper sleeper = new ObjectWaitSleeper();

    public void setSleeper(Sleeper sleeper) {
        this.sleeper = sleeper;
    }

    public void setInitialInterval(long initialInterval) {
        this.initialInterval = initialInterval > 1L ? initialInterval : 1L;
    }

    public void setMultiplier(double multiplier) {
        this.multiplier = multiplier > 1.0 ? multiplier : 1.0;
    }

    public void setMaxInterval(long maxInterval) {
        this.maxInterval = maxInterval > 0L ? maxInterval : 1L;
    }

    public BackOffContext start(RetryContext context) {
        return new ExponentialBackOffContext(this.initialInterval, this.multiplier, this.maxInterval);
    }

    public void backOff(BackOffContext backOffContext) throws BackOffInterruptedException {
        ExponentialBackOffContext context = (ExponentialBackOffContext)backOffContext;
        try {
            this.sleeper.sleep(context.getSleepAndIncrement());
        }
        catch (InterruptedException e) {
            throw new BackOffInterruptedException("Thread interrupted while sleeping", e);
        }
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + "[initialInterval=" + this.initialInterval + ", multiplier=" + this.multiplier + ", maxInterval=" + this.maxInterval + "]";
    }

    private static class ExponentialBackOffContext
    implements BackOffContext {
        private final double multiplier;
        private long interval;
        private long maxInterval;

        public ExponentialBackOffContext(long expSeed, double multiplier, long maxInterval) {
            this.interval = expSeed;
            this.multiplier = multiplier;
            this.maxInterval = maxInterval;
        }

        public synchronized long getSleepAndIncrement() {
            long sleep = this.interval;
            if (sleep > this.maxInterval) {
                sleep = this.maxInterval;
            } else {
                this.interval = (long)((double)this.interval * this.multiplier);
            }
            return sleep;
        }
    }
}

