/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPagingItemReader<T>
extends AbstractPagingItemReader<T> {
    private EntityManagerFactory entityManagerFactory;
    private EntityManager entityManager;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();
    private String queryString;
    private Map<String, Object> parameterValues;

    public JpaPagingItemReader() {
        this.setName(ClassUtils.getShortName(JpaPagingItemReader.class));
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setParameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.entityManagerFactory);
        Assert.hasLength((String)this.queryString);
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    @Override
    protected void doOpen() throws Exception {
        super.doOpen();
        this.entityManager = this.entityManagerFactory.createEntityManager(this.jpaPropertyMap);
        if (this.entityManager == null) {
            throw new DataAccessResourceFailureException("Unable to obtain an EntityManager");
        }
    }

    @Override
    protected void doReadPage() {
        EntityTransaction tx = this.entityManager.getTransaction();
        tx.begin();
        this.entityManager.flush();
        this.entityManager.clear();
        Query query = this.entityManager.createQuery(this.queryString).setFirstResult(this.page * this.pageSize).setMaxResults(this.pageSize);
        if (this.parameterValues != null) {
            for (Map.Entry<String, Object> me : this.parameterValues.entrySet()) {
                query.setParameter(me.getKey(), me.getValue());
            }
        }
        this.results = query.getResultList();
        tx.commit();
    }

    @Override
    protected void doJumpToPage(int itemIndex) {
    }

    @Override
    protected void doClose() throws Exception {
        this.entityManager.close();
        super.doClose();
    }
}

