/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.retry.policy;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.retry.RetryContext;
import org.springframework.batch.retry.RetryPolicy;
import org.springframework.batch.retry.context.RetryContextSupport;

public class CompositeRetryPolicy
implements RetryPolicy {
    RetryPolicy[] policies = new RetryPolicy[0];

    public void setPolicies(RetryPolicy[] policies) {
        this.policies = policies;
    }

    public boolean canRetry(RetryContext context) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        for (int i = 0; i < contexts.length; ++i) {
            if (policies[i].canRetry(contexts[i])) continue;
            return false;
        }
        return true;
    }

    public void close(RetryContext context) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        RuntimeException exception = null;
        for (int i = 0; i < contexts.length; ++i) {
            try {
                policies[i].close(contexts[i]);
                continue;
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public RetryContext open(RetryContext parent) {
        ArrayList<RetryContext> list = new ArrayList<RetryContext>();
        for (int i = 0; i < this.policies.length; ++i) {
            list.add(this.policies[i].open(parent));
        }
        return new CompositeRetryContext(parent, list);
    }

    public void registerThrowable(RetryContext context, Exception throwable) {
        RetryContext[] contexts = ((CompositeRetryContext)context).contexts;
        RetryPolicy[] policies = ((CompositeRetryContext)context).policies;
        for (int i = 0; i < contexts.length; ++i) {
            policies[i].registerThrowable(contexts[i], throwable);
        }
        ((RetryContextSupport)context).registerThrowable(throwable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompositeRetryContext
    extends RetryContextSupport {
        RetryContext[] contexts;
        RetryPolicy[] policies;

        public CompositeRetryContext(RetryContext parent, List<RetryContext> contexts) {
            super(parent);
            this.contexts = contexts.toArray(new RetryContext[0]);
            this.policies = CompositeRetryPolicy.this.policies;
        }
    }
}

