/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support.transaction;

import java.util.ArrayList;
import java.util.List;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class ResourcelessTransactionManager
extends AbstractPlatformTransactionManager {
    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        ((ResourcelessTransaction)transaction).begin();
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Committing resourceless transaction on [" + status.getTransaction() + "]"));
        }
    }

    protected Object doGetTransaction() throws TransactionException {
        List<ResourcelessTransaction> resources;
        ResourcelessTransaction transaction = new ResourcelessTransaction();
        if (!TransactionSynchronizationManager.hasResource((Object)((Object)this))) {
            resources = new ArrayList();
            TransactionSynchronizationManager.bindResource((Object)((Object)this), resources);
        } else {
            List stack = (List)TransactionSynchronizationManager.getResource((Object)((Object)this));
            resources = stack;
        }
        resources.add(transaction);
        return transaction;
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Rolling back resourceless transaction on [" + status.getTransaction() + "]"));
        }
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        if (TransactionSynchronizationManager.hasResource((Object)((Object)this))) {
            List stack = (List)TransactionSynchronizationManager.getResource((Object)((Object)this));
            return stack.size() > 1;
        }
        return ((ResourcelessTransaction)transaction).isActive();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        List resources = (List)TransactionSynchronizationManager.getResource((Object)((Object)this));
        resources.clear();
        TransactionSynchronizationManager.unbindResource((Object)((Object)this));
        ((ResourcelessTransaction)transaction).clear();
    }

    private static class ResourcelessTransaction {
        private boolean active = false;

        private ResourcelessTransaction() {
        }

        public boolean isActive() {
            return this.active;
        }

        public void begin() {
            this.active = true;
        }

        public void clear() {
            this.active = false;
        }
    }
}

