/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data.builder;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.batch.item.data.MongoPagingItemReader;
import org.springframework.batch.item.data.builder.MongoItemReaderBuilder;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class MongoPagingItemReaderBuilder<T>
extends MongoItemReaderBuilder<T> {
    @Override
    public MongoPagingItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> currentItemCount(int currentItemCount) {
        this.currentItemCount = currentItemCount;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> template(MongoOperations template) {
        this.template = template;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> jsonQuery(String query) {
        this.jsonQuery = query;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> targetType(Class<? extends T> targetType) {
        this.targetType = targetType;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> parameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> parameterValues(Object ... parameterValues) {
        return this.parameterValues((List)Arrays.asList(parameterValues));
    }

    @Override
    public MongoPagingItemReaderBuilder<T> fields(String fields) {
        this.fields = fields;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> sorts(Map<String, Sort.Direction> sorts) {
        this.sorts = sorts;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> collection(String collection) {
        this.collection = collection;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> hint(String hint) {
        this.hint = hint;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Override
    public MongoPagingItemReaderBuilder<T> query(Query query) {
        this.query = query;
        return this;
    }

    @Override
    public MongoPagingItemReader<T> build() {
        Assert.notNull((Object)this.template, (String)"template is required.");
        if (this.saveState) {
            Assert.hasText((String)this.name, (String)"A name is required when saveState is set to true");
        }
        Assert.notNull((Object)this.targetType, (String)"targetType is required.");
        Assert.state((StringUtils.hasText((String)this.jsonQuery) || this.query != null ? 1 : 0) != 0, (String)"A query is required");
        if (StringUtils.hasText((String)this.jsonQuery) || this.query != null) {
            Assert.notNull((Object)this.sorts, (String)"sorts map is required.");
        }
        MongoPagingItemReader reader = new MongoPagingItemReader();
        reader.setTemplate(this.template);
        reader.setTargetType(this.targetType);
        reader.setQuery(this.jsonQuery);
        reader.setSort(this.sorts);
        reader.setHint(this.hint);
        reader.setFields(this.fields);
        reader.setCollection(this.collection);
        reader.setParameterValues(this.parameterValues);
        reader.setQuery(this.query);
        reader.setPageSize(this.pageSize);
        reader.setName(this.name);
        reader.setSaveState(this.saveState);
        reader.setCurrentItemCount(this.currentItemCount);
        reader.setMaxItemCount(this.maxItemCount);
        return reader;
    }
}

