/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.util.Assert;

public class JpaItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    protected static final Log logger = LogFactory.getLog(JpaItemWriter.class);
    private EntityManagerFactory entityManagerFactory;
    private boolean usePersist = false;
    private boolean clearPersistenceContext = true;

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public void setUsePersist(boolean usePersist) {
        this.usePersist = usePersist;
    }

    public void setClearPersistenceContext(boolean clearPersistenceContext) {
        this.clearPersistenceContext = clearPersistenceContext;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.entityManagerFactory != null ? 1 : 0) != 0, (String)"An EntityManagerFactory is required");
    }

    @Override
    public void write(Chunk<? extends T> items) {
        EntityManager entityManager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
        if (entityManager == null) {
            throw new DataAccessResourceFailureException("Unable to obtain a transactional EntityManager");
        }
        this.doWrite(entityManager, items);
        entityManager.flush();
        if (this.clearPersistenceContext) {
            entityManager.clear();
        }
    }

    protected void doWrite(EntityManager entityManager, Chunk<? extends T> items) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Writing to JPA with " + items.size() + " items."));
        }
        if (!items.isEmpty()) {
            long addedToContextCount = 0L;
            for (Object item : items) {
                if (entityManager.contains(item)) continue;
                if (this.usePersist) {
                    entityManager.persist(item);
                } else {
                    entityManager.merge(item);
                }
                ++addedToContextCount;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(addedToContextCount + " entities " + (this.usePersist ? " persisted." : "merged.")));
                logger.debug((Object)((long)items.size() - addedToContextCount + " entities found in persistence context."));
            }
        }
    }
}

