/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.support;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.infrastructure.item.ExecutionContext;
import org.springframework.batch.infrastructure.item.ItemStreamException;
import org.springframework.batch.infrastructure.item.ItemStreamReader;

public class CompositeItemReader<T>
implements ItemStreamReader<T> {
    private final List<ItemStreamReader<? extends T>> delegates;
    private final Iterator<ItemStreamReader<? extends T>> delegatesIterator;
    private @Nullable ItemStreamReader<? extends T> currentDelegate;

    public CompositeItemReader(List<ItemStreamReader<? extends T>> delegates) {
        this.delegates = delegates;
        this.delegatesIterator = this.delegates.iterator();
        this.currentDelegate = this.delegatesIterator.hasNext() ? this.delegatesIterator.next() : null;
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        for (ItemStreamReader<T> delegate : this.delegates) {
            delegate.open(executionContext);
        }
    }

    @Override
    public @Nullable T read() throws Exception {
        if (this.currentDelegate == null) {
            return null;
        }
        Object item = this.currentDelegate.read();
        if (item == null) {
            this.currentDelegate = this.delegatesIterator.hasNext() ? this.delegatesIterator.next() : null;
            return this.read();
        }
        return item;
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        if (this.currentDelegate != null) {
            this.currentDelegate.update(executionContext);
        }
    }

    @Override
    public void close() throws ItemStreamException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (ItemStreamReader<T> delegate : this.delegates) {
            try {
                delegate.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            String message = String.format("Failed to close %d delegate(s) due to exceptions", exceptions.size());
            ItemStreamException holder = new ItemStreamException(message);
            exceptions.forEach(holder::addSuppressed);
            throw holder;
        }
    }
}

