/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.infrastructure.item.file.transform;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.infrastructure.item.file.transform.AbstractLineTokenizer;
import org.springframework.batch.infrastructure.item.file.transform.IncorrectLineLengthException;
import org.springframework.batch.infrastructure.item.file.transform.Range;

public class FixedLengthTokenizer
extends AbstractLineTokenizer {
    private Range[] ranges;
    private int maxRange = 0;
    boolean open = false;

    public FixedLengthTokenizer(Range ... ranges) {
        this.ranges = (Range[])ranges.clone();
        this.calculateMaxRange(ranges);
    }

    public void setColumns(Range ... ranges) {
        this.ranges = (Range[])ranges.clone();
        this.calculateMaxRange(ranges);
    }

    private void calculateMaxRange(Range[] ranges) {
        if (ranges.length == 0) {
            this.maxRange = 0;
            return;
        }
        this.open = false;
        this.maxRange = ranges[0].getMin();
        for (Range range : ranges) {
            int upperBound;
            if (range.hasMaxValue()) {
                upperBound = range.getMax();
            } else {
                upperBound = range.getMin();
                if (upperBound > this.maxRange) {
                    this.open = true;
                }
            }
            if (upperBound <= this.maxRange) continue;
            this.maxRange = upperBound;
        }
    }

    @Override
    protected List<String> doTokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>(this.ranges.length);
        int lineLength = line.length();
        if (lineLength < this.maxRange && this.isStrict()) {
            throw new IncorrectLineLengthException("Line is shorter than max range " + this.maxRange, this.maxRange, lineLength, line);
        }
        if (!this.open && lineLength > this.maxRange && this.isStrict()) {
            throw new IncorrectLineLengthException("Line is longer than max range " + this.maxRange, this.maxRange, lineLength, line);
        }
        for (Range range : this.ranges) {
            int startPos = range.getMin() - 1;
            int endPos = range.getMax();
            String token = lineLength >= endPos ? line.substring(startPos, endPos) : (lineLength >= startPos ? line.substring(startPos) : "");
            tokens.add(token);
        }
        return tokens;
    }
}

