/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.test;

import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.core.step.StepExecution;
import org.springframework.batch.infrastructure.item.adapter.HippyMethodInvoker;
import org.springframework.batch.test.MetaDataInstanceFactory;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.ReflectionUtils;

public class StepScopeTestExecutionListener
implements TestExecutionListener {
    private static final String STEP_EXECUTION = StepScopeTestExecutionListener.class.getName() + ".STEP_EXECUTION";

    public void prepareTestInstance(TestContext testContext) {
        StepExecution stepExecution = this.getStepExecution(testContext);
        if (stepExecution != null) {
            testContext.setAttribute(STEP_EXECUTION, (Object)stepExecution);
        }
    }

    public void beforeTestMethod(TestContext testContext) {
        StepExecution stepExecution;
        if (testContext.hasAttribute(STEP_EXECUTION) && (stepExecution = (StepExecution)testContext.getAttribute(STEP_EXECUTION)) != null) {
            StepSynchronizationManager.register((StepExecution)stepExecution);
        }
    }

    public void afterTestMethod(TestContext testContext) {
        if (testContext.hasAttribute(STEP_EXECUTION)) {
            StepSynchronizationManager.close();
        }
    }

    protected StepExecution getStepExecution(TestContext testContext) {
        Object target = testContext.getTestInstance();
        ExtractorMethodCallback method = new ExtractorMethodCallback(StepExecution.class, "getStepExecution");
        ReflectionUtils.doWithMethods(target.getClass(), (ReflectionUtils.MethodCallback)method);
        if (method.getName() != null) {
            HippyMethodInvoker invoker = new HippyMethodInvoker();
            invoker.setTargetObject(target);
            invoker.setTargetMethod(method.getName());
            try {
                invoker.prepare();
                Object invoke = invoker.invoke();
                if (invoke != null) {
                    return (StepExecution)invoke;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not create step execution from method: " + method.getName(), e);
            }
        }
        return MetaDataInstanceFactory.createStepExecution();
    }

    private static final class ExtractorMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final String preferredName;
        private final Class<?> preferredType;
        private @Nullable Method result;

        public ExtractorMethodCallback(Class<?> preferredType, String preferredName) {
            this.preferredType = preferredType;
            this.preferredName = preferredName;
        }

        public @Nullable String getName() {
            return this.result == null ? null : this.result.getName();
        }

        public void doWith(Method method) throws IllegalArgumentException {
            Class<?> type = method.getReturnType();
            if (this.preferredType.isAssignableFrom(type) && (this.result == null || method.getName().equals(this.preferredName))) {
                this.result = method;
            }
        }
    }
}

