/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.CloudFoundryAuthorizationException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

class ReactiveCloudFoundrySecurityService {
    private static final ParameterizedTypeReference<Map<String, Object>> STRING_OBJECT_MAP = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final WebClient webClient;
    private final String cloudControllerUrl;
    private Mono<String> uaaUrl;

    ReactiveCloudFoundrySecurityService(WebClient.Builder webClientBuilder, String cloudControllerUrl) {
        Assert.notNull((Object)webClientBuilder, (String)"Webclient must not be null");
        Assert.notNull((Object)cloudControllerUrl, (String)"CloudControllerUrl must not be null");
        this.webClient = webClientBuilder.build();
        this.cloudControllerUrl = cloudControllerUrl;
    }

    public Mono<AccessLevel> getAccessLevel(String token, String applicationId) throws CloudFoundryAuthorizationException {
        String uri = this.getPermissionsUri(applicationId);
        return this.webClient.get().uri(uri, new Object[0]).header("Authorization", new String[]{"bearer " + token}).retrieve().bodyToMono(Map.class).map(this::getAccessLevel).onErrorMap(this::mapError);
    }

    private Throwable mapError(Throwable throwable) {
        if (throwable instanceof WebClientResponseException) {
            HttpStatus statusCode = ((WebClientResponseException)throwable).getStatusCode();
            if (statusCode.equals((Object)HttpStatus.FORBIDDEN)) {
                return new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.ACCESS_DENIED, "Access denied");
            }
            if (statusCode.is4xxClientError()) {
                return new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "Invalid token", throwable);
            }
        }
        return new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Cloud controller not reachable");
    }

    private AccessLevel getAccessLevel(Map<?, ?> body) {
        if (Boolean.TRUE.equals(body.get("read_sensitive_data"))) {
            return AccessLevel.FULL;
        }
        return AccessLevel.RESTRICTED;
    }

    private String getPermissionsUri(String applicationId) {
        return this.cloudControllerUrl + "/v2/apps/" + applicationId + "/permissions";
    }

    public Mono<Map<String, String>> fetchTokenKeys() {
        return this.getUaaUrl().flatMap(this::fetchTokenKeys);
    }

    private Mono<? extends Map<String, String>> fetchTokenKeys(String url) {
        WebClient.RequestHeadersSpec uri = this.webClient.get().uri(url + "/token_keys", new Object[0]);
        return uri.retrieve().bodyToMono(STRING_OBJECT_MAP).map(this::extractTokenKeys).onErrorMap(ex -> new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, ex.getMessage()));
    }

    private Map<String, String> extractTokenKeys(Map<String, Object> response) {
        HashMap<String, String> tokenKeys = new HashMap<String, String>();
        for (Object key : (List)response.get("keys")) {
            Map tokenKey = (Map)key;
            tokenKeys.put((String)tokenKey.get("kid"), (String)tokenKey.get("value"));
        }
        return tokenKeys;
    }

    public Mono<String> getUaaUrl() {
        this.uaaUrl = this.webClient.get().uri(this.cloudControllerUrl + "/info", new Object[0]).retrieve().bodyToMono(Map.class).map(response -> (String)response.get("token_endpoint")).cache().onErrorMap(ex -> new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.SERVICE_UNAVAILABLE, "Unable to fetch token keys from UAA."));
        return this.uaaUrl;
    }
}

