/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.AccessLevel;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.SecurityResponse;
import org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundrySecurityInterceptor;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.OperationInvoker;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMappingException;
import org.springframework.boot.actuate.endpoint.reflect.ParametersMissingException;
import org.springframework.boot.actuate.endpoint.web.EndpointLinksResolver;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.Link;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.servlet.AbstractWebMvcEndpointHandlerMapping;
import org.springframework.boot.endpoint.web.EndpointMapping;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.servlet.HandlerMapping;

class CloudFoundryWebEndpointServletHandlerMapping
extends AbstractWebMvcEndpointHandlerMapping {
    private final Method handle = ReflectionUtils.findMethod(OperationHandler.class, (String)"handle", (Class[])new Class[]{HttpServletRequest.class, Map.class});
    private final Method links = ReflectionUtils.findMethod(CloudFoundryWebEndpointServletHandlerMapping.class, (String)"links", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
    private static final Log logger = LogFactory.getLog(CloudFoundryWebEndpointServletHandlerMapping.class);
    private final CloudFoundrySecurityInterceptor securityInterceptor;
    private final EndpointLinksResolver endpointLinksResolver = new EndpointLinksResolver();

    CloudFoundryWebEndpointServletHandlerMapping(EndpointMapping endpointMapping, Collection<EndpointInfo<WebOperation>> webEndpoints, EndpointMediaTypes endpointMediaTypes, CorsConfiguration corsConfiguration, CloudFoundrySecurityInterceptor securityInterceptor) {
        super(endpointMapping, webEndpoints, endpointMediaTypes, corsConfiguration);
        this.securityInterceptor = securityInterceptor;
    }

    protected Method getLinks() {
        return this.links;
    }

    @ResponseBody
    private Map<String, Map<String, Link>> links(HttpServletRequest request, HttpServletResponse response) {
        SecurityResponse securityResponse = this.securityInterceptor.preHandle(request, "");
        if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
            this.sendFailureResponse(response, securityResponse);
        }
        AccessLevel accessLevel = (AccessLevel)((Object)request.getAttribute("cloudFoundryAccessLevel"));
        Map links = this.endpointLinksResolver.resolveLinks(this.getEndpoints(), request.getRequestURL().toString());
        Map<Object, Object> filteredLinks = new LinkedHashMap();
        if (accessLevel == null) {
            return Collections.singletonMap("_links", filteredLinks);
        }
        filteredLinks = links.entrySet().stream().filter(e -> ((String)e.getKey()).equals("self") || accessLevel.isAccessAllowed((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Collections.singletonMap("_links", filteredLinks);
    }

    private void sendFailureResponse(HttpServletResponse response, SecurityResponse securityResponse) {
        try {
            response.sendError(securityResponse.getStatus().value(), securityResponse.getMessage());
        }
        catch (Exception ex) {
            logger.debug((Object)"Failed to send error response", (Throwable)ex);
        }
    }

    protected void registerMappingForOperation(WebOperation operation) {
        this.registerMapping(this.createRequestMappingInfo(operation), new OperationHandler(operation.getInvoker(), operation.getId(), this.securityInterceptor), this.handle);
    }

    final class OperationHandler {
        private final OperationInvoker operationInvoker;
        private final String endpointId;
        private final CloudFoundrySecurityInterceptor securityInterceptor;

        OperationHandler(OperationInvoker operationInvoker, String id, CloudFoundrySecurityInterceptor securityInterceptor) {
            this.operationInvoker = operationInvoker;
            this.endpointId = id;
            this.securityInterceptor = securityInterceptor;
        }

        @ResponseBody
        public Object handle(HttpServletRequest request, @RequestBody(required=false) Map<String, String> body) {
            SecurityResponse securityResponse = this.securityInterceptor.preHandle(request, this.endpointId);
            if (!securityResponse.getStatus().equals((Object)HttpStatus.OK)) {
                return this.failureResponse(securityResponse);
            }
            HashMap<String, String> arguments = new HashMap<String, String>((Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE));
            HttpMethod httpMethod = HttpMethod.valueOf((String)request.getMethod());
            if (body != null && HttpMethod.POST == httpMethod) {
                arguments.putAll(body);
            }
            request.getParameterMap().forEach((name, values) -> arguments.put((String)name, (String)(((String[])values).length == 1 ? values[0] : Arrays.asList(values))));
            try {
                return this.handleResult(this.operationInvoker.invoke(arguments), httpMethod);
            }
            catch (ParameterMappingException | ParametersMissingException ex) {
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
        }

        private Object failureResponse(SecurityResponse response) {
            return this.handleResult(new WebEndpointResponse((Object)response.getMessage(), response.getStatus().value()));
        }

        private Object handleResult(Object result) {
            return this.handleResult(result, null);
        }

        private Object handleResult(Object result, HttpMethod httpMethod) {
            if (result == null) {
                return new ResponseEntity(httpMethod == HttpMethod.GET ? HttpStatus.NOT_FOUND : HttpStatus.NO_CONTENT);
            }
            if (!(result instanceof WebEndpointResponse)) {
                return result;
            }
            WebEndpointResponse response = (WebEndpointResponse)result;
            return new ResponseEntity(response.getBody(), HttpStatus.valueOf((int)response.getStatus()));
        }
    }
}

