/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.condition;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.Condition;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

@Endpoint(id="conditions")
public class ConditionsReportEndpoint {
    private final ConditionEvaluationReport conditionEvaluationReport;

    public ConditionsReportEndpoint(ConditionEvaluationReport conditionEvaluationReport) {
        this.conditionEvaluationReport = conditionEvaluationReport;
    }

    @ReadOperation
    public Report getEvaluationReport() {
        return new Report(this.conditionEvaluationReport);
    }

    @JsonPropertyOrder(value={"condition", "message"})
    public static class MessageAndCondition {
        private final String condition;
        private final String message;

        public MessageAndCondition(ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome) {
            Condition condition = conditionAndOutcome.getCondition();
            ConditionOutcome outcome = conditionAndOutcome.getOutcome();
            this.condition = ClassUtils.getShortName(condition.getClass());
            this.message = StringUtils.hasLength((String)outcome.getMessage()) ? outcome.getMessage() : (outcome.isMatch() ? "matched" : "did not match");
        }

        public String getCondition() {
            return this.condition;
        }

        public String getMessage() {
            return this.message;
        }
    }

    @JsonPropertyOrder(value={"notMatched", "matched"})
    public static class MessageAndConditions {
        private final List<MessageAndCondition> notMatched = new ArrayList<MessageAndCondition>();
        private final List<MessageAndCondition> matched = new ArrayList<MessageAndCondition>();

        public MessageAndConditions(ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
                List<MessageAndCondition> target = conditionAndOutcome.getOutcome().isMatch() ? this.matched : this.notMatched;
                target.add(new MessageAndCondition(conditionAndOutcome));
            }
        }

        public List<MessageAndCondition> getNotMatched() {
            return this.notMatched;
        }

        public List<MessageAndCondition> getMatched() {
            return this.matched;
        }
    }

    @JsonPropertyOrder(value={"positiveMatches", "negativeMatches", "exclusions", "unconditionalClasses"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class Report {
        private final MultiValueMap<String, MessageAndCondition> positiveMatches = new LinkedMultiValueMap();
        private final Map<String, MessageAndConditions> negativeMatches = new LinkedHashMap<String, MessageAndConditions>();
        private final List<String> exclusions;
        private final Set<String> unconditionalClasses;
        private final Report parent;

        public Report(ConditionEvaluationReport report) {
            this.exclusions = report.getExclusions();
            this.unconditionalClasses = report.getUnconditionalClasses();
            for (Map.Entry entry : report.getConditionAndOutcomesBySource().entrySet()) {
                if (((ConditionEvaluationReport.ConditionAndOutcomes)entry.getValue()).isFullMatch()) {
                    this.add(this.positiveMatches, (String)entry.getKey(), (ConditionEvaluationReport.ConditionAndOutcomes)entry.getValue());
                    continue;
                }
                this.add(this.negativeMatches, (String)entry.getKey(), (ConditionEvaluationReport.ConditionAndOutcomes)entry.getValue());
            }
            boolean hasParent = report.getParent() != null;
            this.parent = hasParent ? new Report(report.getParent()) : null;
        }

        private void add(Map<String, MessageAndConditions> map, String source, ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            String name = ClassUtils.getShortName((String)source);
            map.put(name, new MessageAndConditions(conditionAndOutcomes));
        }

        private void add(MultiValueMap<String, MessageAndCondition> map, String source, ConditionEvaluationReport.ConditionAndOutcomes conditionAndOutcomes) {
            String name = ClassUtils.getShortName((String)source);
            for (ConditionEvaluationReport.ConditionAndOutcome conditionAndOutcome : conditionAndOutcomes) {
                map.add((Object)name, (Object)new MessageAndCondition(conditionAndOutcome));
            }
        }

        public Map<String, List<MessageAndCondition>> getPositiveMatches() {
            return this.positiveMatches;
        }

        public Map<String, MessageAndConditions> getNegativeMatches() {
            return this.negativeMatches;
        }

        public List<String> getExclusions() {
            return this.exclusions;
        }

        public Set<String> getUnconditionalClasses() {
            return this.unconditionalClasses;
        }

        public Report getParent() {
            return this.parent;
        }
    }
}

