/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.EndpointPathProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointInfo;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.util.Assert;

public class DefaultEndpointPathProvider
implements EndpointPathProvider {
    private final String basePath;
    private final EndpointDiscoverer<WebOperation> endpointDiscoverer;

    public DefaultEndpointPathProvider(EndpointDiscoverer<WebOperation> endpointDiscoverer, WebEndpointProperties webEndpointProperties) {
        this.endpointDiscoverer = endpointDiscoverer;
        this.basePath = webEndpointProperties.getBasePath();
    }

    @Override
    public List<String> getPaths() {
        return this.getEndpoints().map(this::getPath).collect(Collectors.toList());
    }

    @Override
    public String getPath(String id) {
        Assert.notNull((Object)id, (String)"ID must not be null");
        return this.getEndpoints().filter(info -> id.equals(info.getId())).findFirst().map(this::getPath).orElse(null);
    }

    private Stream<EndpointInfo<WebOperation>> getEndpoints() {
        return this.endpointDiscoverer.discoverEndpoints().stream();
    }

    private String getPath(EndpointInfo<WebOperation> endpointInfo) {
        return this.basePath + "/" + endpointInfo.getId();
    }
}

