/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.ExposeExcludePropertyEndpointFilter;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.DefaultEndpointPathProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.DefaultEndpointPathResolver;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.EndpointPathProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.endpoint.EndpointDiscoverer;
import org.springframework.boot.actuate.endpoint.EndpointFilter;
import org.springframework.boot.actuate.endpoint.reflect.OperationMethodInvokerAdvisor;
import org.springframework.boot.actuate.endpoint.reflect.ParameterMapper;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.EndpointPathResolver;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebAnnotationEndpointDiscoverer;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={EndpointAutoConfiguration.class})
@EnableConfigurationProperties(value={WebEndpointProperties.class})
@ConditionalOnProperty(name={"management.endpoints.web.enabled"}, matchIfMissing=true)
public class WebEndpointAutoConfiguration {
    private static final List<String> MEDIA_TYPES = Arrays.asList("application/vnd.spring-boot.actuator.v2+json", "application/json");
    private final ApplicationContext applicationContext;
    private final WebEndpointProperties properties;

    public WebEndpointAutoConfiguration(ApplicationContext applicationContext, WebEndpointProperties properties) {
        this.applicationContext = applicationContext;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public EndpointPathResolver endpointPathResolver() {
        return new DefaultEndpointPathResolver(this.properties.getPathMapping());
    }

    @Bean
    @ConditionalOnMissingBean
    public WebAnnotationEndpointDiscoverer webAnnotationEndpointDiscoverer(ParameterMapper parameterMapper, EndpointPathResolver endpointPathResolver, Collection<OperationMethodInvokerAdvisor> invokerAdvisors, Collection<EndpointFilter<WebOperation>> filters) {
        return new WebAnnotationEndpointDiscoverer(this.applicationContext, parameterMapper, this.endpointMediaTypes(), endpointPathResolver, invokerAdvisors, filters);
    }

    @Bean
    @ConditionalOnMissingBean
    public EndpointMediaTypes endpointMediaTypes() {
        return new EndpointMediaTypes(MEDIA_TYPES, MEDIA_TYPES);
    }

    @Bean
    @ConditionalOnMissingBean
    public EndpointPathProvider endpointPathProvider(EndpointDiscoverer<WebOperation> endpointDiscoverer, WebEndpointProperties webEndpointProperties) {
        return new DefaultEndpointPathProvider(endpointDiscoverer, webEndpointProperties);
    }

    @Bean
    public ExposeExcludePropertyEndpointFilter<WebOperation> webIncludeExcludePropertyEndpointFilter() {
        return new ExposeExcludePropertyEndpointFilter<WebOperation>(WebAnnotationEndpointDiscoverer.class, this.properties.getExpose(), this.properties.getExclude(), "info", "health");
    }
}

