/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
class MeterBindersConfiguration {
    MeterBindersConfiguration() {
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.binders.jvmmemory.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={JvmMemoryMetrics.class})
    public JvmMemoryMetrics jvmMemoryMetrics() {
        return new JvmMemoryMetrics();
    }

    @Bean
    @ConditionalOnMissingBean(value={LogbackMetrics.class})
    @ConditionalOnProperty(value={"spring.metrics.binders.logback.enabled"}, matchIfMissing=true)
    @ConditionalOnClass(name={"ch.qos.logback.classic.Logger"})
    public LogbackMetrics logbackMetrics() {
        return new LogbackMetrics();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.binders.uptime.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={UptimeMetrics.class})
    public UptimeMetrics uptimeMetrics() {
        return new UptimeMetrics();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.metrics.binders.processor.enabled"}, matchIfMissing=true)
    @ConditionalOnMissingBean(value={ProcessorMetrics.class})
    public ProcessorMetrics processorMetrics() {
        return new ProcessorMetrics();
    }
}

