/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.Arrays;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.core.annotation.Order;
import org.springframework.util.ObjectUtils;

@Order(value=0x7FFFFFFE)
class CompositeMeterRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
BeanFactoryAware {
    private static final String COMPOSITE_BEAN_NAME = "compositeMeterRegistry";
    private ConfigurableListableBeanFactory beanFactory;

    CompositeMeterRegistryPostProcessor() {
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        }
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        if (this.beanFactory == null) {
            return;
        }
        String[] registryBeans = this.beanFactory.getBeanNamesForType(MeterRegistry.class, true, false);
        this.registerCompositeIfNecessary(registry, registryBeans);
    }

    private void registerCompositeIfNecessary(BeanDefinitionRegistry registry, String[] registryBeans) {
        if (ObjectUtils.isEmpty((Object[])registryBeans)) {
            this.registerNoOpMeterRegistry(registry);
        }
        if (registryBeans.length > 1 && !this.hasPrimaryDefinition(registryBeans)) {
            this.registerPrimaryCompositeMeterRegistry(registry, registryBeans);
        }
    }

    private boolean hasPrimaryDefinition(String[] registryBeans) {
        return Arrays.stream(registryBeans).map(arg_0 -> ((ConfigurableListableBeanFactory)this.beanFactory).getBeanDefinition(arg_0)).anyMatch(BeanDefinition::isPrimary);
    }

    private void registerNoOpMeterRegistry(BeanDefinitionRegistry registry) {
        GenericBeanDefinition definition = new GenericBeanDefinition();
        definition.setBeanClass(CompositeMeterRegistry.class);
        registry.registerBeanDefinition(COMPOSITE_BEAN_NAME, (BeanDefinition)definition);
    }

    private void registerPrimaryCompositeMeterRegistry(BeanDefinitionRegistry registry, String[] registryBeans) {
        GenericBeanDefinition definition = new GenericBeanDefinition();
        definition.setBeanClass(CompositeMeterRegistry.class);
        definition.setPrimary(true);
        definition.setAutowireMode(3);
        ConstructorArgumentValues arguments = new ConstructorArgumentValues();
        arguments.addIndexedArgumentValue(1, this.getBeanReferences(registryBeans));
        definition.setConstructorArgumentValues(arguments);
        registry.registerBeanDefinition(COMPOSITE_BEAN_NAME, (BeanDefinition)definition);
    }

    private ManagedList<RuntimeBeanReference> getBeanReferences(String[] names) {
        ManagedList references = new ManagedList(names.length);
        Arrays.stream(names).map(RuntimeBeanReference::new).forEach(arg_0 -> references.add(arg_0));
        return references;
    }
}

