/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.kafka;

import java.time.Duration;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.autoconfigure.health.HealthIndicatorAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.kafka.KafkaHealthIndicatorProperties;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.kafka.KafkaHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.kafka.KafkaAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@ConditionalOnClass(value={KafkaAdmin.class})
@ConditionalOnBean(value={KafkaAdmin.class})
@ConditionalOnEnabledHealthIndicator(value="kafka")
@AutoConfigureBefore(value={HealthIndicatorAutoConfiguration.class})
@AutoConfigureAfter(value={KafkaAutoConfiguration.class})
@EnableConfigurationProperties(value={KafkaHealthIndicatorProperties.class})
public class KafkaHealthIndicatorAutoConfiguration
extends CompositeHealthIndicatorConfiguration<KafkaHealthIndicator, KafkaAdmin> {
    private final Map<String, KafkaAdmin> admins;
    private final KafkaHealthIndicatorProperties properties;

    public KafkaHealthIndicatorAutoConfiguration(Map<String, KafkaAdmin> admins, KafkaHealthIndicatorProperties properties) {
        this.admins = admins;
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(name={"kafkaHealthIndicator"})
    public HealthIndicator kafkaHealthIndicator() {
        return this.createHealthIndicator(this.admins);
    }

    @Override
    protected KafkaHealthIndicator createHealthIndicator(KafkaAdmin source) {
        Duration responseTimeout = this.properties.getResponseTimeout();
        return new KafkaHealthIndicator(source, responseTimeout.toMillis());
    }
}

