/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cassandra;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeHealthIndicatorConfiguration;
import org.springframework.boot.actuate.cassandra.CassandraHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.core.CassandraOperations;

@Configuration
@ConditionalOnClass(value={CassandraOperations.class})
@ConditionalOnBean(value={CassandraOperations.class})
class CassandraHealthIndicatorConfiguration
extends CompositeHealthIndicatorConfiguration<CassandraHealthIndicator, CassandraOperations> {
    private final Map<String, CassandraOperations> cassandraOperations;

    CassandraHealthIndicatorConfiguration(Map<String, CassandraOperations> cassandraOperations) {
        this.cassandraOperations = cassandraOperations;
    }

    @Bean
    @ConditionalOnMissingBean(name={"cassandraHealthIndicator"})
    public HealthIndicator cassandraHealthIndicator() {
        return this.createHealthIndicator(this.cassandraOperations);
    }
}

