/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.cassandra;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.health.CompositeReactiveHealthIndicatorConfiguration;
import org.springframework.boot.actuate.cassandra.CassandraReactiveHealthIndicator;
import org.springframework.boot.actuate.health.ReactiveHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;

@Configuration
@ConditionalOnClass(value={ReactiveCassandraOperations.class})
@ConditionalOnBean(value={ReactiveCassandraOperations.class})
class CassandraReactiveHealthIndicatorConfiguration
extends CompositeReactiveHealthIndicatorConfiguration<CassandraReactiveHealthIndicator, ReactiveCassandraOperations> {
    private final Map<String, ReactiveCassandraOperations> reactiveCassandraOperations;

    CassandraReactiveHealthIndicatorConfiguration(Map<String, ReactiveCassandraOperations> reactiveCassandraOperations) {
        this.reactiveCassandraOperations = reactiveCassandraOperations;
    }

    @Bean
    @ConditionalOnMissingBean(name={"cassandraReactiveHealthIndicator"})
    public ReactiveHealthIndicator cassandraHealthIndicator() {
        return this.createHealthIndicator(this.reactiveCassandraOperations);
    }
}

